*                                                                                  ;
 *    Reading in the 1991 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam91.raw' ;
 
 data one;
 
   infile 'F:\PSID\91FAM.DAT'  lrecl=2336 missover;
   INPUT
   V19001 1-3             V19002 4-8             V19003 9-10
   V19004 11-13           V19005 14-18           V19006 19
   V19007 20              V19008 21              V19009 22
   V19010 23              V19011 24              V19012 25
   V19013 26              V19014 27              V19015 28
   V19016 29              V19017 30-33           V19018 34-36
   V19019 37-38           V19020 39              V19021 40-41
   V19022 42              V19023 43              V19024 44-49
   V19025 50              V19026 51-56           V19027 57
   V19028 58-62           V19029 63              V19030 64-68
   V19031 69              V19032 70-73           V19033 74-78
   V19034 79              V19035 80-83           V19036 84
   V19037 85-88           V19038 89-92           V19039 93
   V19040 94-97           V19041 98              V19042 99-102
   V19043 103             V19044 104-107         V19045 108-111
   V19046 112             V19047 113-116         V19048 117
   V19049 118-121         V19050 122             V19051 123-126
   V19052 127             V19053 128-131         V19054 132
   V19055 133             V19056 134             V19057 135
   V19058 136             V19059 137             V19060 138
   V19061 139             V19062 140             V19063 141
   V19064 142             V19065 143             V19066 144
   V19067 145             V19068 146-149         V19069 150
   V19070 151-154         V19071 155             V19072 156-159
   V19073 160             V19074 161-164         V19075 165-168
   V19076 169             V19077 170-173         V19078 174
   V19079 175-178         V19080 179             V19081 180-183
   V19082 184             V19083 185-188         V19084 189
   V19085 190             V19086 191             V19087 192
   V19088 193             V19089 194             V19090 195
   V19091 196             V19092 197             V19093 198
   V19094 199             V19095 200             V19096 201
   V19097 202             V19098 203-204         V19099 205
   V19100 206-209         V19101 210             V19102 211-214
   V19103 215             V19104 216             V19105 217-219
   V19106 220             V19107 221-225         V19108 226
   V19109 227-230         V19110 231             V19111 232-235
   V19112 236             V19113 237-238         V19114 239
   V19115 240             V19116 241             V19117 242
   V19118 243             V19119 244             V19120 245
   V19121 246             V19122 247             V19123 248
   V19124 249             V19125 250             V19126 251
   V19127 252-256         V19128 257-261         V19129 262-267
   V19130 268             V19131 269-273         V19132 274-279
   V19133 280-284         V19134 285-289         V19135 290
   V19136 291-296         V19137 297             V19138 298-303
   V19139 304-309         V19140 310-314         V19141 315-319
   V19142 320-325         V19143 326-327         V19144 328-333
   V19145 334-335         V19146 336-341         V19147 342-343
   V19148 344-349         V19149 350-355         V19150 356
   V19151 357-363         V19152 364-368         V19153 369-373
   V19154 374-378         V19155 379             V19156 380-381
   V19157 382             V19158 383             V19159 384-388
   V19160 389             V19161 390-391         V19162 392-396
   V19163 397-401         V19164 402-403         V19165 404-408
   V19166 409             V19167 410-411         V19168 412-416
   V19169 417-418         V19170 419-423         V19171 424
   V19172 425-429         V19173 430-434         V19174 435-436
   V19175 437-441         V19176 442-443         V19177 444-448
   V19178 449-450         V19179 451-455         V19180 456-460
   V19181 461             V19182 462-463         V19183 464-468
   V19184 469-473         V19185 474-475         V19186 476-480
   V19187 481             V19188 482-483         V19189 484-488
   V19190 489-490         V19191 491-495         V19192 496-500
   V19193 501-505         V19194 506-507         V19195 508-512
   V19196 513-514         V19197 515-519         V19198 520-521
   V19199 522-526         V19200 527             V19201 528-532
   V19202 533             V19203 534             V19204 535
   V19205 536             V19206 537             V19207 538
   V19208 539             V19209 540             V19210 541
   V19211 542             V19212 543             V19213 544
   V19214 545             V19215 546             V19216 547
   V19217 548             V19218 549             V19219 550
   V19220 551             V19221 552             V19222 553
   V19223 554             V19224 555             V19225 556
   V19226 557             V19227 558             V19228 559
   V19229 560             V19230 561             V19231 562
   V19232 563             V19233 564             V19234 565
   V19235 566             V19236 567             V19237 568
   V19238 569             V19239 570             V19240 571
   V19241 572             V19242 573             V19243 574
   V19244 575             V19245 576             V19246 577
   V19247 578             V19248 579             V19249 580
   V19250 581             V19251 582             V19252 583
   V19253 584             V19254 585             V19255 586
   V19256 587             V19257 588             V19258 589
   V19259 590             V19260 591             V19261 592
   V19262 593             V19263 594             V19264 595
   V19265 596             V19266 597             V19267 598
   V19268 599             V19269 600             V19270 601
   V19271 602             V19272 603             V19273 604
   V19274 605             V19275 606-607         V19276 608-609
   V19277 610-615         V19278 616-617         V19279 618
   V19280 619-620         V19281 621-622         V19282 623-628
   V19283 629-630         V19284 631             V19285 632-633
   V19286 634-635         V19287 636-641         V19288 642-643
   V19289 644             V19290 645-646         V19291 647-648
   V19292 649-654         V19293 655-656         V19294 657
   V19295 658-659         V19296 660-661         V19297 662-667
   V19298 668-669         V19299 670             V19300 671-674
   V19301 675-680         V19302 681             V19303 682-686
   V19304 687             V19305 688-692         V19306 693-697
   V19307 698-702         V19308 703-707         V19309 708-712
   V19310 713-717         V19311 718-722         V19312 723-727
   V19313 728-732         V19314 733-737         V19315 738-742
   V19316 743-747         V19317 748-752         V19318 753
   V19319 754             V19320 755             V19321 756-759
   V19322 760-763         V19323 764-767         V19324 768-771
   V19325 772-775         V19326 776-779         V19327 780-783
   V19328 784-787         V19329 788-791         V19330 792-795
   V19331 796-799         V19332 800-803         V19333 804-807
   V19334 808-811         V19335 812-815         V19336 816-819
   V19337 820-823         V19338 824-827         V19339 828-831
   V19340 832-835         V19341 836-839         V19342 840-843
   V19343 844-848         V19344 849-852         V19345 853-855
   V19346 856-859         V19347 860-862         V19348 863-864
   V19349 865-866         V19350 867             V19351 868-869
   V19352 870-871         V19353 872-873         V19354 874-875
   V19355 876             V19356 877             V19357 878
   V19358 879             V19359 880             V19360 881
   V19361 882             V19362 883             V19363 884
   V19364 885             V19365 886             V19366 887
   V19367 888             V19368 889-890         V19369 891-892
   V19370 893-894         V19371 895             V19372 896
   V19373 897             V19374 898-899         V19375 900
   V19376 901             V19377 902             V19378 903
   V19379 904             V19380 905             V19381 906
   V19382 907             V19383 908             V19384 909
   V19385 910             V19386 911             V19387 912
   V19388 913-914         V19389 915             V19390 916
   V19391 917             V19392 918             V19393 919
   V19394 920-921         V19395 922             V19396 923
   V19397 924             V19398 925             V19399 926
   V19400 927             V19401 928-930         V19402 931-933
   V19403 934             V19404 935-938         V19405 939
   V19406 940-943         V19407 944-947         V19408 948-951
   V19409 952             V19410 953-956         V19411 957
   V19412 958             V19413 959             V19414 960
   V19415 961             V19416 962             V19417 963
   V19418 964             V19419 965             V19420 966-968
   V19421 969-970         V19422 971-972         V19423 973
   V19424 974-975         V19425 976-977         V19426 978
   V19427 979-980         V19428 981             V19429 982-983
   V19430 984-985         V19431 986-987         V19432 988-989
   V19433 990             V19434 991-992         V19435 993
   V19436 994-996         V19437 997-1000        V19438 1001-1002
   V19439 1003            V19440 1004            V19441 1005
   V19442 1006            V19443 1007            V19444 1008
   V19445 1009            V19446 1010            V19447 1011
   V19448 1012            V19449 1013            V19450 1014
   V19451 1015            V19452 1016-1017       V19453 1018-1019
   V19454 1020            V19455 1021            V19456 1022
   V19457 1023            V19458 1024            V19459 1025
   V19460 1026            V19461 1027            V19462 1028
   V19463 1029            V19464 1030            V19465 1031
   V19466 1032            V19467 1033            V19468 1034
   V19469 1035-1037       V19470 1038-1040       V19471 1041-1044
   V19472 1045-1046       V19473 1047            V19474 1048-1049
   V19475 1050            V19476 1051            V19477 1052-1053
   V19478 1054-1055       V19479 1056            V19480 1057-1060
   V19481 1061-1062       V19482 1063            V19483 1064-1065
   V19484 1066            V19485 1067-1068       V19486 1069
   V19487 1070-1071       V19488 1072            V19489 1073-1074
   V19490 1075            V19491 1076-1077       V19492 1078
   V19493 1079-1080       V19494 1081            V19495 1082-1083
   V19496 1084-1085       V19497 1086-1087       V19498 1088
   V19499 1089            V19500 1090            V19501 1091
   V19502 1092-1094       V19503 1095-1097       V19504 1098-1101
   V19505 1102-1103       V19506 1104-1105       V19507 1106-1107
   V19508 1108-1109       V19509 1110            V19510 1111
   V19511 1112            V19512 1113            V19513 1114
   V19514 1115            V19515 1116            V19516 1117
   V19517 1118            V19518 1119            V19519 1120
   V19520 1121            V19521 1122            V19522 1123-1124
   V19523 1125-1126       V19524 1127            V19525 1128-1130
   V19526 1131-1133       V19527 1134-1137       V19528 1138-1139
   V19529 1140-1141       V19530 1142-1143       V19531 1144-1145
   V19532 1146            V19533 1147            V19534 1148
   V19535 1149            V19536 1150            V19537 1151
   V19538 1152            V19539 1153            V19540 1154
   V19541 1155            V19542 1156            V19543 1157
   V19544 1158            V19545 1159-1160       V19546 1161-1162
   V19547 1163            V19548 1164            V19549 1165
   V19550 1166            V19551 1167            V19552 1168
   V19553 1169            V19554 1170            V19555 1171
   V19556 1172-1173       V19557 1174            V19558 1175-1176
   V19559 1177-1178       V19560 1179            V19561 1180-1181
   V19562 1182-1184       V19563 1185-1187       V19564 1188
   V19565 1189            V19566 1190            V19567 1191
   V19568 1192-1193       V19569 1194-1195       V19570 1196
   V19571 1197-1198       V19572 1199-1200       V19573 1201
   V19574 1202-1203       V19575 1204            V19576 1205-1206
   V19577 1207-1208       V19578 1209-1210       V19579 1211-1212
   V19580 1213            V19581 1214-1215       V19582 1216
   V19583 1217-1219       V19584 1220-1223       V19585 1224-1225
   V19586 1226            V19587 1227            V19588 1228
   V19589 1229            V19590 1230            V19591 1231
   V19592 1232            V19593 1233            V19594 1234
   V19595 1235            V19596 1236            V19597 1237
   V19598 1238            V19599 1239-1240       V19600 1241-1242
   V19601 1243            V19602 1244            V19603 1245
   V19604 1246            V19605 1247            V19606 1248
   V19607 1249            V19608 1250            V19609 1251
   V19610 1252            V19611 1253            V19612 1254
   V19613 1255            V19614 1256            V19615 1257
   V19616 1258-1260       V19617 1261-1263       V19618 1264-1267
   V19619 1268-1269       V19620 1270            V19621 1271-1272
   V19622 1273            V19623 1274            V19624 1275-1276
   V19625 1277-1278       V19626 1279            V19627 1280-1283
   V19628 1284-1285       V19629 1286            V19630 1287-1288
   V19631 1289            V19632 1290-1291       V19633 1292
   V19634 1293-1294       V19635 1295            V19636 1296-1297
   V19637 1298            V19638 1299-1300       V19639 1301
   V19640 1302-1303       V19641 1304            V19642 1305-1306
   V19643 1307-1308       V19644 1309-1310       V19645 1311
   V19646 1312            V19647 1313            V19648 1314
   V19649 1315-1317       V19650 1318-1320       V19651 1321-1324
   V19652 1325-1326       V19653 1327-1328       V19654 1329-1330
   V19655 1331-1332       V19656 1333            V19657 1334
   V19658 1335            V19659 1336            V19660 1337
   V19661 1338            V19662 1339            V19663 1340
   V19664 1341            V19665 1342            V19666 1343
   V19667 1344            V19668 1345            V19669 1346-1347
   V19670 1348-1349       V19671 1350            V19672 1351-1353
   V19673 1354-1356       V19674 1357-1360       V19675 1361-1362
   V19676 1363-1364       V19677 1365-1366       V19678 1367-1368
   V19679 1369            V19680 1370            V19681 1371
   V19682 1372            V19683 1373            V19684 1374
   V19685 1375            V19686 1376            V19687 1377
   V19688 1378            V19689 1379            V19690 1380
   V19691 1381            V19692 1382-1383       V19693 1384-1385
   V19694 1386            V19695 1387            V19696 1388-1389
   V19697 1390            V19698 1391            V19699 1392
   V19700 1393            V19701 1394            V19702 1395
   V19703 1396-1398       V19704 1399-1401       V19705 1402
   V19706 1403-1406       V19707 1407            V19708 1408-1411
   V19709 1412-1415       V19710 1416-1419       V19711 1420
   V19712 1421-1424       V19713 1425            V19714 1426
   V19715 1427            V19716 1428            V19717 1429
   V19718 1430            V19719 1431            V19720 1432
   V19721 1433            V19722 1434-1436       V19723 1437-1438
   V19724 1439-1440       V19725 1441            V19726 1442-1443
   V19727 1444-1445       V19728 1446            V19729 1447-1448
   V19730 1449            V19731 1450-1451       V19732 1452-1453
   V19733 1454-1455       V19734 1456-1457       V19735 1458
   V19736 1459-1460       V19737 1461            V19738 1462-1464
   V19739 1465-1468       V19740 1469-1470       V19741 1471
   V19742 1472            V19743 1473            V19744 1474
   V19745 1475            V19746 1476            V19747 1477
   V19748 1478            V19749 1479            V19750 1480
   V19751 1481            V19752 1482            V19753 1483
   V19754 1484-1485       V19755 1486-1487       V19756 1488
   V19757 1489            V19758 1490            V19759 1491
   V19760 1492            V19761 1493            V19762 1494
   V19763 1495            V19764 1496            V19765 1497
   V19766 1498            V19767 1499            V19768 1500
   V19769 1501            V19770 1502            V19771 1503-1505
   V19772 1506-1508       V19773 1509-1512       V19774 1513-1514
   V19775 1515            V19776 1516-1517       V19777 1518
   V19778 1519            V19779 1520-1521       V19780 1522-1523
   V19781 1524            V19782 1525-1528       V19783 1529-1530
   V19784 1531            V19785 1532-1533       V19786 1534
   V19787 1535-1536       V19788 1537            V19789 1538-1539
   V19790 1540            V19791 1541-1542       V19792 1543
   V19793 1544-1545       V19794 1546            V19795 1547-1548
   V19796 1549            V19797 1550-1551       V19798 1552-1553
   V19799 1554-1555       V19800 1556            V19801 1557
   V19802 1558            V19803 1559            V19804 1560-1562
   V19805 1563-1565       V19806 1566-1569       V19807 1570-1571
   V19808 1572-1573       V19809 1574-1575       V19810 1576-1577
   V19811 1578            V19812 1579            V19813 1580
   V19814 1581            V19815 1582            V19816 1583
   V19817 1584            V19818 1585            V19819 1586
   V19820 1587            V19821 1588            V19822 1589
   V19823 1590            V19824 1591-1592       V19825 1593-1594
   V19826 1595            V19827 1596-1598       V19828 1599-1601
   V19829 1602-1605       V19830 1606-1607       V19831 1608-1609
   V19832 1610-1611       V19833 1612-1613       V19834 1614
   V19835 1615            V19836 1616            V19837 1617
   V19838 1618            V19839 1619            V19840 1620
   V19841 1621            V19842 1622            V19843 1623
   V19844 1624            V19845 1625            V19846 1626
   V19847 1627-1628       V19848 1629-1630       V19849 1631
   V19850 1632            V19851 1633            V19852 1634
   V19853 1635            V19854 1636            V19855 1637
   V19856 1638            V19857 1639            V19858 1640-1641
   V19859 1642            V19860 1643-1644       V19861 1645-1646
   V19862 1647            V19863 1648-1649       V19864 1650-1652
   V19865 1653-1655       V19866 1656            V19867 1657
   V19868 1658            V19869 1659            V19870 1660-1661
   V19871 1662-1663       V19872 1664            V19873 1665-1666
   V19874 1667-1668       V19875 1669            V19876 1670-1671
   V19877 1672            V19878 1673-1674       V19879 1675-1676
   V19880 1677-1678       V19881 1679-1680       V19882 1681
   V19883 1682-1683       V19884 1684            V19885 1685-1687
   V19886 1688-1691       V19887 1692-1693       V19888 1694
   V19889 1695            V19890 1696            V19891 1697
   V19892 1698            V19893 1699            V19894 1700
   V19895 1701            V19896 1702            V19897 1703
   V19898 1704            V19899 1705            V19900 1706
   V19901 1707-1708       V19902 1709-1710       V19903 1711
   V19904 1712            V19905 1713            V19906 1714
   V19907 1715            V19908 1716            V19909 1717
   V19910 1718            V19911 1719            V19912 1720
   V19913 1721            V19914 1722            V19915 1723
   V19916 1724            V19917 1725            V19918 1726-1728
   V19919 1729-1731       V19920 1732-1735       V19921 1736-1737
   V19922 1738            V19923 1739-1740       V19924 1741
   V19925 1742            V19926 1743-1744       V19927 1745-1746
   V19928 1747            V19929 1748-1751       V19930 1752-1753
   V19931 1754            V19932 1755-1756       V19933 1757
   V19934 1758-1759       V19935 1760            V19936 1761-1762
   V19937 1763            V19938 1764-1765       V19939 1766
   V19940 1767-1768       V19941 1769            V19942 1770-1771
   V19943 1772            V19944 1773-1774       V19945 1775-1776
   V19946 1777-1778       V19947 1779            V19948 1780
   V19949 1781            V19950 1782            V19951 1783-1785
   V19952 1786-1788       V19953 1789-1792       V19954 1793-1794
   V19955 1795-1796       V19956 1797-1798       V19957 1799-1800
   V19958 1801            V19959 1802            V19960 1803
   V19961 1804            V19962 1805            V19963 1806
   V19964 1807            V19965 1808            V19966 1809
   V19967 1810            V19968 1811            V19969 1812
   V19970 1813            V19971 1814-1815       V19972 1816-1817
   V19973 1818            V19974 1819-1821       V19975 1822-1824
   V19976 1825-1828       V19977 1829-1830       V19978 1831-1832
   V19979 1833-1834       V19980 1835-1836       V19981 1837
   V19982 1838            V19983 1839            V19984 1840
   V19985 1841            V19986 1842            V19987 1843
   V19988 1844            V19989 1845            V19990 1846
   V19991 1847            V19992 1848            V19993 1849
   V19994 1850-1851       V19995 1852-1853       V19996 1854
   V19997 1855-1856       V19998 1857-1858       V19999 1859
   V20000 1860-1864       V20001 1865            V20002 1866-1871
   V20003 1872            V20004 1873-1874       V20005 1875
   V20006 1876            V20007 1877            V20008 1878
   V20009 1879-1884       V20010 1885-1890       V20011 1891
   V20012 1892            V20013 1893-1894       V20014 1895-1896
   V20015 1897-1898       V20016 1899-1900       V20017 1901
   V20018 1902            V20019 1903            V20020 1904
   V20021 1905            V20022 1906            V20023 1907
   V20024 1908            V20025 1909            V20026 1910
   V20027 1911            V20028 1912            V20029 1913
   V20030 1914            V20031 1915            V20032 1916
   V20033 1917            V20034 1918            V20035 1919
   V20036 1920            V20037 1921-1922       V20038 1923
   V20039 1924            V20040 1925-1926       V20041 1927
   V20042 1928            V20043 1929-1930       V20044 1931
   V20045 1932            V20046 1933-1934       V20047 1935
   V20048 1936            V20049 1937            V20050 1938
   V20051 1939            V20052 1940            V20053 1941-1942
   V20054 1943-1944       V20055 1945-1946       V20056 1947-1948
   V20057 1949-1950       V20058 1951-1952       V20059 1953
   V20060 1954-1955       V20061 1956            V20062 1957
   V20063 1958-1959       V20064 1960-1961       V20065 1962
   V20066 1963            V20067 1964            V20068 1965-1966
   V20069 1967-1968       V20070 1969-1970       V20071 1971
   V20072 1972-1973       V20073 1974-1975       V20074 1976-1977
   V20075 1978            V20076 1979-1980       V20077 1981-1982
   V20078 1983-1984       V20079 1985-1986       V20080 1987-1988
   V20081 1989-1990       V20082 1991            V20083 1992-1993
   V20084 1994-1996       V20085 1997-1998       V20086 1999-2001
   V20087 2002            V20088 2003            V20089 2004
   V20090 2005            V20091 2006-2007       V20092 2008-2010
   V20093 2011            V20094 2012            V20095 2013
   V20096 2014            V20097 2015            V20098 2016
   V20099 2017            V20100 2018            V20101 2019-2020
   V20102 2021            V20103 2022            V20104 2023-2024
   V20105 2025            V20106 2026            V20107 2027-2028
   V20108 2029            V20109 2030            V20110 2031-2032
   V20111 2033            V20112 2034            V20113 2035
   V20114 2036            V20115 2037            V20116 2038
   V20117 2039            V20118 2040-2041       V20119 2042-2043
   V20120 2044-2045       V20121 2046-2047       V20122 2048-2049
   V20123 2050-2051       V20124 2052-2053       V20125 2054-2055
   V20126 2056-2057       V20127 2058-2059       V20128 2060
   V20129 2061-2062       V20130 2063-2064       V20131 2065
   V20132 2066            V20133 2067-2068       V20134 2069-2070
   V20135 2071-2072       V20136 2073            V20137 2074
   V20138 2075            V20139 2076-2077       V20140 2078-2079
   V20141 2080-2081       V20142 2082-2083       V20143 2084
   V20144 2085-2086       V20145 2087-2088       V20146 2089-2090
   V20147 2091-2092       V20148 2093            V20149 2094-2095
   V20150 2096-2097       V20151 2098-2099       V20152 2100-2101
   V20153 2102-2103       V20154 2104-2105       V20155 2106-2107
   V20156 2108            V20157 2109-2110       V20158 2111
   V20159 2112            V20160 2113            V20161 2114-2115
   V20162 2116-2121       V20163 2122-2123       V20164 2124-2128
   V20165 2129-2130       V20166 2131-2135       V20167 2136-2137
   V20168 2138-2142       V20169 2143-2144       V20170 2145-2149
   V20171 2150-2151       V20172 2152-2156       V20173 2157-2158
   V20174 2159-2164       V20175 2165-2171       V20176 2172-2174
   V20177 2175-2177       V20178 2178-2183       V20179 2184-2186
   V20180 2187-2189       V20181 2190-2194 .2    V20182 2195-2199
   V20183 2200-2204 .2    V20184 2205-2209       V20185 2210-2213 .2
   V20186 2214-2217       V20187 2218-2221 .2    V20188 2222-2225 .2
   V20189 2226            V20190 2227-2228       V20191 2229-2231
   V20192 2232-2233       V20193 2234            V20194 2235
   V20195 2236            V20196 2237-2238       V20197 2239-2240
   V20198 2241-2242       V20199 2243-2244       V20200 2245
   V20201 2246            V20202 2247            V20203 2248
   V20204 2249            V20205 2250            V20206 2251
   V20207 2252            V20208 2253            V20209 2254
   V20210 2255            V20211 2256            V20212 2257
   V20213 2258            V20214 2259            V20215 2260-2261
   V20216 2262            V20217 2263            V20218 2264
   V20219 2265-2266       V20220 2267-2268       V20221 2269
   V20222 2270            V20223 2271-2275       V20224 2276-2280
   V20225 2281            V20226 2282-2283       V20227 2284-2288
   V20228 2289            V20229 2290-2291       V20230 2292-2296
   V20231 2297            V20232 2298-2299       V20233 2300-2304
   V20234 2305            V20235 2306-2307       V20236 2308-2312
   V20237 2313            V20238 2314            V20239 2315
   V20240 2316            V20241 2317            V20242 2318
   V20243 2319-2324 .3    V20244 2325-2330 .3    V20245 2331-2336 .3;

* SAS LABEL STATEMENT;

LABEL
   V19001 = "STUDY NUMBER (714)"
   V19002 = "1991 INTERVIEW NUMBER"
   V19003 = "CURRENT STATE"
   V19004 = "CURRENT COUNTY"
   V19005 = "CURRENT STATE+CNTY"
   V19006 = "SIZE LGST CITY/COUNTY 91"
   V19007 = "SPLITOFF INDICATOR    91"
   V19008 = "WHETHER REFUSED       91"
   V19009 = "MODE OF INTERVIEW     91"
   V19010 = "FAM COMP CHANGE       91"
   V19011 = "NUMBER MOVED IN       91"
   V19012 = "WHO MOVED IN          91"
   V19013 = "NUMBER MOVED OUT      91"
   V19014 = "WHO MOVED OUT         91"
   V19015 = "CURRENT FAM COMP      91"
   V19016 = "CURRENT HSEHOLD COMP  91"
   V19017 = "68 ID# OF HOUSEHOLDER 91"
   V19018 = "PERS# OF HOUSEHOLDER  91"
   V19019 = "AGE OF HOUSEHOLDER    91"
   V19020 = "SEX OF HOUSEHOLDER    91"
   V19021 = "REL HHOLDER TO FU HD  91"
   V19022 = "QUALITY OF MATCH      91"
   V19023 = "TYPE INSTITUTION      91"
   V19024 = "1991 HOUSE VALUE  (A16)"
   V19025 = "ACC 91 HOUSE VALUE"
   V19026 = "1991 REM MORT PRIN (A20)"
   V19027 = "ACC REM MORT PRIN"
   V19028 = "TOTAL ANN MRTG PMT (A21)"
   V19029 = "ACC TOT ANN MRTG PMT"
   V19030 = "91 ANN PROP TAX (A17)"
   V19031 = "ACC ANN PROP TAX"
   V19032 = "ANN HOMEOWNER INS (A18)"
   V19033 = "ANN RENT (A27)"
   V19034 = "ACC ANN RENT"
   V19035 = "ANN VAL FREE HSNG (A33)"
   V19036 = "ACC ANN VAL FREE HSNG"
   V19037 = "GOV SUBSIDY OF HTG (A14)"
   V19038 = "HD MAIN JOB WRKHRS 90"
   V19039 = "ACC HD 90 MAIN JOB WRKHR"
   V19040 = "HD OVERTIME WRKHRS 90"
   V19041 = "ACC HD 90 OVERTIME WRKHR"
   V19042 = "HD XTRA JOB WRKHRS 90"
   V19043 = "ACC HD 90 XTRA JOB WRKHR"
   V19044 = "HD ANN WRK HRS IN 90"
   V19045 = "HD HRS WRK LOST OTR ILL"
   V19046 = "ACC HD HR LOST OTR ILL"
   V19047 = "HD HRS WRK LOST OWN ILL"
   V19048 = "ACC HD HRS LOST OWN ILL"
   V19049 = "HD STRIKE HOURS 90"
   V19050 = "ACC HD STRIKE HRS 90"
   V19051 = "HD UNEMP HRS 90"
   V19052 = "ACC 90 HD UNEMP HRS"
   V19053 = "HD HRS OUT LBR FORCE 90"
   V19054 = "ACC 90 HD HR OUT LBR FRC"
   V19055 = "HD UNEMP/OUT LBR JAN 90"
   V19056 = "HD UNEMP/OUT LBR FEB 90"
   V19057 = "HD UNEMP/OUT LBR MAR 90"
   V19058 = "HD UNEMP/OUT LBR APR 90"
   V19059 = "HD UNEMP/OUT LBR MAY 90"
   V19060 = "HD UNEMP/OUT LBR JUN 90"
   V19061 = "HD UNEMP/OUT LBR JUL 90"
   V19062 = "HD UNEMP/OUT LBR AUG 90"
   V19063 = "HD UNEMP/OUT LBR SEP 90"
   V19064 = "HD UNEMP/OUT LBR OCT 90"
   V19065 = "HD UNEMP/OUT LBR NOV 90"
   V19066 = "HD UNEMP/OUT LBR DEC 90"
   V19067 = "WIFE IN FU?"
   V19068 = "WF MAIN JOB WRKHRS 90"
   V19069 = "ACC WF 90 MAIN JOB WRKHR"
   V19070 = "WF OVERTIME WRKHRS 90"
   V19071 = "ACC WF 90 OVERTIME WRKHR"
   V19072 = "WF XTRA JOB WRKHRS 90"
   V19073 = "ACC WF 90 XTRA JOB WRKHR"
   V19074 = "WF ANN WRK HRS IN 90"
   V19075 = "WF HRS WRK LOST OTR ILL"
   V19076 = "ACC WF HR LOST OTR ILL"
   V19077 = "WF HRS WRK LOST OWN ILL"
   V19078 = "ACC WF HRS LOST OWN ILL"
   V19079 = "WF STRIKE HOURS 90"
   V19080 = "ACC WF STRIKE HRS 90"
   V19081 = "WF UNEMP HRS 90"
   V19082 = "ACC WF UNEMP HRS 90"
   V19083 = "WF HRS OUT LBR FORCE 90"
   V19084 = "ACC WF 90 HR OUT LBR FRC"
   V19085 = "WF UNEMP/OUT LBR JAN 90"
   V19086 = "WF UNEMP/OUT LBR FEB 90"
   V19087 = "WF UNEMP/OUT LBR MAR 90"
   V19088 = "WF UNEMP/OUT LBR APR 90"
   V19089 = "WF UNEMP/OUT LBR MAY 90"
   V19090 = "WF UNEMP/OUT LBR JUN 90"
   V19091 = "WF UNEMP/OUT LBR JUL 90"
   V19092 = "WF UNEMP/OUT LBR AUG 90"
   V19093 = "WF UNEMP/OUT LBR SEP 90"
   V19094 = "WF UNEMP/OUT LBR OCT 90"
   V19095 = "WF UNEMP/OUT LBR NOV 90"
   V19096 = "WF UNEMP/OUT LBR DEC 90"
   V19097 = "# MAJOR ADULTS"
   V19098 = "1991 FAMILY SIZE"
   V19099 = "# REQUIRED ROOMS"
   V19100 = "WIFE ANN HOUSEWORK  (F2)"
   V19101 = "ACC WIFE ANN HOUSEWORK"
   V19102 = "HEAD ANN HOUSEWORK  (F3)"
   V19103 = "ACC HEAD ANN HOUSEWORK"
   V19104 = "# IN HH GOT FD ST LST MO"
   V19105 = "VALUE FD ST LST MO (F10)"
   V19106 = "ACC VALUE FD ST LST MO"
   V19107 = "ANN FD COST-HOME"
   V19108 = "ACC HOME FD COST"
   V19109 = "ANN FD COST-EAT OUT"
   V19110 = "ACC EAT OUT FD COST"
   V19111 = "VALUE FD ST 90     (F21)"
   V19112 = "ACC VALUE FD ST 90"
   V19113 = "# MOS USED FD ST 90(F22)"
   V19114 = "WTR USED FD ST JAN 90"
   V19115 = "WTR USED FD ST FEB 90"
   V19116 = "WTR USED FD ST MAR 90"
   V19117 = "WTR USED FD ST APR 90"
   V19118 = "WTR USED FD ST MAY 90"
   V19119 = "WTR USED FD ST JUN 90"
   V19120 = "WTR USED FD ST JUL 90"
   V19121 = "WTR USED FD ST AUG 90"
   V19122 = "WTR USED FD ST SEP 90"
   V19123 = "WTR USED FD ST OCT 90"
   V19124 = "WTR USED FD ST NOV 90"
   V19125 = "WTR USED FD ST DEC 90"
   V19126 = "HD/WF HAVE TXBL Y?"
   V19127 = "LABOR PART FARM Y 90"
   V19128 = "LABOR PART BUS Y 90"
   V19129 = "HEAD 90 WAGES"
   V19130 = "ACC HEAD 90 WAGES"
   V19131 = "HD BONUS/OT/COMM 90"
   V19132 = "HD PROF PRAC/TRADE 90"
   V19133 = "LABOR PT MKT GARDEN 90"
   V19134 = "LABOR PT ROOMERS 90"
   V19135 = "ACC HD LABOR Y EXC WAGES"
   V19136 = "WIFE 90 LABOR/WAGE"
   V19137 = "ACC WF 90 LABOR/WAGE"
   V19138 = "ASSET PART FARM Y 90"
   V19139 = "ASSET PART BUS Y 90"
   V19140 = "ASSET PT MKT GARDN 90"
   V19141 = "ASSET PT ROOMERS 90"
   V19142 = "WF PT ASSET INCOME 90"
   V19143 = "HD # MO RECD RENT 90"
   V19144 = "HD RENT 90"
   V19145 = "HD # MO RECD INT/DIV 90"
   V19146 = "HD INT/DIVIDENDS 90"
   V19147 = "HD #MO RECD ALIMONY 90"
   V19148 = "ALIMONY Y HEAD 90"
   V19149 = "WF 90 OTHER ASSET Y"
   V19150 = "ACC H+W 90 ASSET Y"
   V19151 = "H+W 90 TAXABLE Y"
   V19152 = "H+W 90 SUPP OTR NONFU"
   V19153 = "H+W CHLD SUPPORT PAID 90"
   V19154 = "H+W ALIMONY PAID 90"
   V19155 = "XTRA XMPTS FOR BLIND"
   V19156 = "H+W TOTAL 90 EXEMPTION"
   V19157 = "1990 TAX TABLE USED-H+W"
   V19158 = "HD/WF REC TRANSFER Y 90?"
   V19159 = "HD 90 ADC/AFDC"
   V19160 = "ACC HD 90 ADC/AFDC"
   V19161 = "HD # MO RECEIVE SSI 90"
   V19162 = "HD 90 SSI"
   V19163 = "HD 90 OTR WELFARE"
   V19164 = "HD #MO RECD SOC SEC 90"
   V19165 = "HD 90 SOCIAL SECURITY"
   V19166 = "HD TYPE SOC SEC 90"
   V19167 = "HD #MO REC VA PENSION 90"
   V19168 = "HD 90 VA PENSION"
   V19169 = "HD #MO RECD OTR RET 90"
   V19170 = "HD OTHER RETIREMENT 90"
   V19171 = "HD # OTR PENS RCD 90"
   V19172 = "HD 90 UNEMP COMP"
   V19173 = "HD 90 WORKERS COMP"
   V19174 = "HD #MO REC CHILD SUPP 90"
   V19175 = "HD 90 CHILD SUPPORT"
   V19176 = "HD #MO REC HLP FR REL 90"
   V19177 = "HD 90 HELP FROM RELS"
   V19178 = "HD #MO REC OTR TRAN Y 90"
   V19179 = "HD 90 OTHER TRANSFER Y"
   V19180 = "WF 90 ADC/AFDC"
   V19181 = "ACC WF 90 ADC/AFDC"
   V19182 = "WF # MO RECEIVE SSI 90"
   V19183 = "WF 90 SSI"
   V19184 = "WF 90 OTR WELFARE"
   V19185 = "WF #MO RECD SOC SEC 90"
   V19186 = "WF 90 SOCIAL SECURITY"
   V19187 = "WF TYPE SOC SEC 90"
   V19188 = "WF #MO REC VA PENSION 90"
   V19189 = "WF 90 VA PENSION"
   V19190 = "WF #MO RECD OTR RET 90"
   V19191 = "WF OTHER RETIREMENT 90"
   V19192 = "WF 90 UNEMP COMP"
   V19193 = "WF 90 WORKERS COMP"
   V19194 = "WF #MO REC CHILD SUPP 90"
   V19195 = "WF 90 CHILD SUPPORT"
   V19196 = "WF #MO REC HLP FR REL 90"
   V19197 = "WF 90 HELP FROM RELS"
   V19198 = "WF #MO REC OTR TRAN Y 90"
   V19199 = "WF 90 OTHER TRANSFER Y"
   V19200 = "ACC H+W 90 TRANS EXC ADC"
   V19201 = "H+W 90 TOT TRANSFER Y"
   V19202 = "H+W RECD ADC/AFDC JAN 90"
   V19203 = "H+W RECD ADC/AFDC FEB 90"
   V19204 = "H+W RECD ADC/AFDC MAR 90"
   V19205 = "H+W RECD ADC/AFDC APR 90"
   V19206 = "H+W RECD ADC/AFDC MAY 90"
   V19207 = "H+W RECD ADC/AFDC JUN 90"
   V19208 = "H+W RECD ADC/AFDC JUL 90"
   V19209 = "H+W RECD ADC/AFDC AUG 90"
   V19210 = "H+W RECD ADC/AFDC SEP 90"
   V19211 = "H+W RECD ADC/AFDC OCT 90"
   V19212 = "H+W RECD ADC/AFDC NOV 90"
   V19213 = "H+W RECD ADC/AFDC DEC 90"
   V19214 = "H+W REC OTR WELFR JAN 90"
   V19215 = "H+W REC OTR WELFR FEB 90"
   V19216 = "H+W REC OTR WELFR MAR 90"
   V19217 = "H+W REC OTR WELFR APR 90"
   V19218 = "H+W REC OTR WELFR MAY 90"
   V19219 = "H+W REC OTR WELFR JUN 90"
   V19220 = "H+W REC OTR WELFR JUL 90"
   V19221 = "H+W REC OTR WELFR AUG 90"
   V19222 = "H+W REC OTR WELFR SEP 90"
   V19223 = "H+W REC OTR WELFR OCT 90"
   V19224 = "H+W REC OTR WELFR NOV 90"
   V19225 = "H+W REC OTR WELFR DEC 90"
   V19226 = "HD REC UNEMP COMP JAN 90"
   V19227 = "HD REC UNEMP COMP FEB 90"
   V19228 = "HD REC UNEMP COMP MAR 90"
   V19229 = "HD REC UNEMP COMP APR 90"
   V19230 = "HD REC UNEMP COMP MAY 90"
   V19231 = "HD REC UNEMP COMP JUN 90"
   V19232 = "HD REC UNEMP COMP JUL 90"
   V19233 = "HD REC UNEMP COMP AUG 90"
   V19234 = "HD REC UNEMP COMP SEP 90"
   V19235 = "HD REC UNEMP COMP OCT 90"
   V19236 = "HD REC UNEMP COMP NOV 90"
   V19237 = "HD REC UNEMP COMP DEC 90"
   V19238 = "WF REC UNEMP COMP JAN 90"
   V19239 = "WF REC UNEMP COMP FEB 90"
   V19240 = "WF REC UNEMP COMP MAR 90"
   V19241 = "WF REC UNEMP COMP APR 90"
   V19242 = "WF REC UNEMP COMP MAY 90"
   V19243 = "WF REC UNEMP COMP JUN 90"
   V19244 = "WF REC UNEMP COMP JUL 90"
   V19245 = "WF REC UNEMP COMP AUG 90"
   V19246 = "WF REC UNEMP COMP SEP 90"
   V19247 = "WF REC UNEMP COMP OCT 90"
   V19248 = "WF REC UNEMP COMP NOV 90"
   V19249 = "WF REC UNEMP COMP DEC 90"
   V19250 = "HD REC WORKR COMP JAN 90"
   V19251 = "HD REC WORKR COMP FEB 90"
   V19252 = "HD REC WORKR COMP MAR 90"
   V19253 = "HD REC WORKR COMP APR 90"
   V19254 = "HD REC WORKR COMP MAY 90"
   V19255 = "HD REC WORKR COMP JUN 90"
   V19256 = "HD REC WORKR COMP JUL 90"
   V19257 = "HD REC WORKR COMP AUG 90"
   V19258 = "HD REC WORKR COMP SEP 90"
   V19259 = "HD REC WORKR COMP OCT 90"
   V19260 = "HD REC WORKR COMP NOV 90"
   V19261 = "HD REC WORKR COMP DEC 90"
   V19262 = "WF REC WORKR COMP JAN 90"
   V19263 = "WF REC WORKR COMP FEB 90"
   V19264 = "WF REC WORKR COMP MAR 90"
   V19265 = "WF REC WORKR COMP APR 90"
   V19266 = "WF REC WORKR COMP MAY 90"
   V19267 = "WF REC WORKR COMP JUN 90"
   V19268 = "WF REC WORKR COMP JUL 90"
   V19269 = "WF REC WORKR COMP AUG 90"
   V19270 = "WF REC WORKR COMP SEP 90"
   V19271 = "WF REC WORKR COMP OCT 90"
   V19272 = "WF REC WORKR COMP NOV 90"
   V19273 = "WF REC WORKR COMP DEC 90"
   V19274 = "OFUM REC TXBL Y 90?"
   V19275 = "SEQ# 1ST OFUM W TXBL Y"
   V19276 = "P PRORAT TXBL Y 1ST OFUM"
   V19277 = "TXBL Y 1ST XTRA EARNER"
   V19278 = "# EXEMP 1ST XTRA EARNER"
   V19279 = "TAX TABLE 1ST XTRA EARNR"
   V19280 = "SEQ# 2ND OFUM W TXBL Y"
   V19281 = "P PRORAT TXBL Y 2ND OFUM"
   V19282 = "TXBL Y 2ND XTRA EARNER"
   V19283 = "# EXEMP 2ND XTRA EARNER"
   V19284 = "TAX TABLE 2ND XTRA EARNR"
   V19285 = "SEQ# 3RD OFUM W TXBL Y"
   V19286 = "P PRORAT TXBL Y 3RD OFUM"
   V19287 = "TXBL Y 3RD XTRA EARNER"
   V19288 = "# EXEMP 3RD XTRA EARNER"
   V19289 = "TAX TABLE 3RD XTRA EARNR"
   V19290 = "SEQ# 4TH OFUM W TXBL Y"
   V19291 = "P PRORAT TXBL Y 4TH OFUM"
   V19292 = "TXBL Y 4TH XTRA EARNER"
   V19293 = "# EXEMP 4TH XTRA EARNER"
   V19294 = "TAX TABLE 4TH XTRA EARNR"
   V19295 = "SEQ# 5TH OFUM W TXBL Y"
   V19296 = "P PRORAT TXBL Y 5TH OFUM"
   V19297 = "TXBL Y 5TH XTRA EARNER"
   V19298 = "# EXEMP 5TH XTRA EARNER"
   V19299 = "TAX TABLE 5TH XTRA EARNR"
   V19300 = "OFUM 90 ANN WRK HRS"
   V19301 = "OFUM 90 TOT ANN TXBL Y"
   V19302 = "ACC OFUM ANN TXBL Y 90"
   V19303 = "OFUM 90 ASSET Y"
   V19304 = "OFUM REC TRANSFER Y?"
   V19305 = "OFUM 90 ADC/AFDC"
   V19306 = "OFUM 90 SSI"
   V19307 = "OFUM 90 OTHER WELFARE"
   V19308 = "OFUM 90 SOC SECURITY"
   V19309 = "OFUM 90 VA PAYMENTS"
   V19310 = "OFUM 90 OTR RETIREMENT"
   V19311 = "OFUM 90 UNEMP COMP"
   V19312 = "OFUM 90 WORKERS COMP"
   V19313 = "OFUM 90 CHILD SUPPORT"
   V19314 = "OFUM 90 HELP FROM RELS"
   V19315 = "OFUM 90 MISC TRANSFERS"
   V19316 = "NOPRO TOT TRANS Y OFUM90"
   V19317 = "PRO TOT TRANS Y OFUM 90"
   V19318 = "ACC OFUM 90 TRANSFERS"
   V19319 = "# OFUM Y RECEIVERS 90"
   V19320 = "# OFUM LABOR Y RECRS 90"
   V19321 = "1968 ID"
   V19322 = "1969 ID"
   V19323 = "1970 ID"
   V19324 = "1971 ID"
   V19325 = "1972 ID"
   V19326 = "1973 ID"
   V19327 = "1974 ID"
   V19328 = "1975 ID"
   V19329 = "1976 ID"
   V19330 = "1977 ID"
   V19331 = "1978 ID"
   V19332 = "1979 ID"
   V19333 = "1980 ID"
   V19334 = "1981 ID"
   V19335 = "1982 ID"
   V19336 = "1983 ID"
   V19337 = "1984 ID"
   V19338 = "1985 ID"
   V19339 = "1986 ID"
   V19340 = "1987 ID"
   V19341 = "1988 ID"
   V19342 = "1989 ID"
   V19343 = "1990 ID"
   V19344 = "INTERVIEWER ID # 1991"
   V19345 = "INTERVIEWER INTVIEW #"
   V19346 = "DATE OF 1991 IW"
   V19347 = "LENGTH OF 1991 IW"
   V19348 = "# IN FU"
   V19349 = "AGE OF 1991 HEAD"
   V19350 = "SEX OF 1991 HEAD"
   V19351 = "AGE OF 1991 WIFE"
   V19352 = "# CHILDREN IN FU"
   V19353 = "AGE YOUNGEST CHILD"
   V19354 = "# NONFU SHARING HU"
   V19355 = "A3 MARITAL STATUS"
   V19356 = "A4 TYPE DU"
   V19357 = "A6 LIVE IN ELDERLY HSNG"
   V19358 = "A7 TYPE ELDERLY HSNG"
   V19359 = "A8 PROVIDE XTRA SERVICES"
   V19360 = "A9A PROVIDE NURSING CARE"
   V19361 = "A9B PROVIDE TRANSPORTN"
   V19362 = "A9C PROVIDE COMMON MEALS"
   V19363 = "A9D PROVIDE MAID SERVICE"
   V19364 = "A9E PROVIDE LAUNDRY"
   V19365 = "A9F PROVIDE RECREATION"
   V19366 = "A9G PROVIDE OTHER SERVCS"
   V19367 = "A10 SERVICES INCLUDED"
   V19368 = "A11 TYPE HEATING #1"
   V19369 = "A11 TYPE HEATING #2"
   V19370 = "A12 ACTUAL # ROOMS"
   V19371 = "A13 RECD GOVT HTG SUBSDY"
   V19372 = "A15 OWN/RENT OR WHAT"
   V19373 = "A19 HAVE MORTGAGE?"
   V19374 = "A23 #YRS LEFT TO PAY MTG"
   V19375 = "A24 SECOND MORTGAGE?"
   V19376 = "A25 MTG INCL PROP TAXES"
   V19377 = "A26 MTG INCL INS PREM"
   V19378 = "A28 FURNISHED APT/HOUSE"
   V19379 = "A29 RENT INCL HEAT"
   V19380 = "A30 IN PUBLIC OWND PROJ?"
   V19381 = "A31 GOVT PAY PART RENT?"
   V19382 = "A32 WHY NOT OWN/RENT"
   V19383 = "A34 IN PUBLIC OWND PROJ?"
   V19384 = "A35 GOVT PAY ALL RENT?"
   V19385 = "A36 HAVE AIR CONDITNG"
   V19386 = "A37 A/C ALL OR SOME ROOM"
   V19387 = "A38 MOVED SINCE SPG 90?"
   V19388 = "A39 MONTH MOVED"
   V19389 = "A40 WHY MOVED"
   V19390 = "A41 WTR MIGHT MOVE"
   V19391 = "A42 LIKELIHOOD OF MOVING"
   V19392 = "A43 WHY MIGHT MOVE"
   V19393 = "B1 EMPLOYMENT STATUS-HD"
   V19394 = "B2 YEAR RETIRED   (HD-R)"
   V19395 = "B3 WORK FOR MONEY?(HD-E)"
   V19396 = "B4 WORK SELF/OTR? (HD-E)"
   V19397 = "B5 CORP/UNCORP BUS(HD-E)"
   V19398 = "B6 WORK FOR GOVT? (HD-E)"
   V19399 = "B7 JOB NOW UNION?  (H-E)"
   V19400 = "B8 BELONG UNION?  (HD-E)"
   V19401 = "B9-10 MAIN OCC:3 DIG H-E"
   V19402 = "B11 MAIN IND:3 DIGT(H-E)"
   V19403 = "B12 SLRY/HRLY/OTR  (H-E)"
   V19404 = "B13 PAY/HR-SALARY (HD-E)"
   V19405 = "B14 WTR SAL PD OT (HD-E)"
   V19406 = "B15 PAY/HR-SLRYOT (HD-E)"
   V19407 = "B16 PAY/HR-HOURLY (HD-E)"
   V19408 = "B17 PAY/HR-HRLY OT (H-E)"
   V19409 = "B18 HOW PAID-OTR  (HD-E)"
   V19410 = "B19 PAY/HR-OTR OT  (H-E)"
   V19411 = "B20 GET NEW JOB?  (HD-E)"
   V19412 = "B21 DONE NOTHING   (H-E)"
   V19413 = "B21 PUBLIC EMP AGCY(H-E)"
   V19414 = "B21 PRIVATE EMP AGY(H-E)"
   V19415 = "B21 CURR EMP DIRECT(H-E)"
   V19416 = "B21 OTR EMPR DIRECT(H-E)"
   V19417 = "B21 FRIEND OR REL  (H-E)"
   V19418 = "B21 PLACE OR ANS AD(H-E)"
   V19419 = "B21 OTHER          (H-E)"
   V19420 = "B23 #MO PRESENT EMP(H-E)"
   V19421 = "B24 MO BEG PRES EMP(H-E)"
   V19422 = "B24 YR BEG PRES EMP(H-E)"
   V19423 = "B25 BEG WRK PRES POS H-E"
   V19424 = "B26 MO BEG PRES POS(H-E)"
   V19425 = "B26 YR BEG PRES POS(H-E)"
   V19426 = "B27 CHGE POS IN 90(HD-E)"
   V19427 = "B28 MO CHGE POS   (HD-E)"
   V19428 = "B29 TYPE OF CHGE  (HD-E)"
   V19429 = "B30 MO BEG PRES POS(H-E)"
   V19430 = "B30 YR BEG PRES POS(H-E)"
   V19431 = "B31 MO BEG PRES POS(H-E)"
   V19432 = "B31 YR BEG PRES POS(H-E)"
   V19433 = "B32 CHGE POS IN 91(HD-E)"
   V19434 = "B33 MO CHGE POS   (HD-E)"
   V19435 = "B34 TYPE OF CHGE  (HD-E)"
   V19436 = "B35-36 BEG OCC PRES EMP"
   V19437 = "B37 STARTING WAGE  (H-E)"
   V19438 = "B38 STARTING HR/WK (H-E)"
   V19439 = "B39 PRES EMP JAN90 (H-E)"
   V19440 = "B39 PRES EMP FEB90 (H-E)"
   V19441 = "B39 PRES EMP MAR90 (H-E)"
   V19442 = "B39 PRES EMP APR90 (H-E)"
   V19443 = "B39 PRES EMP MAY90 (H-E)"
   V19444 = "B39 PRES EMP JUN90 (H-E)"
   V19445 = "B39 PRES EMP JUL90 (H-E)"
   V19446 = "B39 PRES EMP AUG90 (H-E)"
   V19447 = "B39 PRES EMP SEP90 (H-E)"
   V19448 = "B39 PRES EMP OCT90 (H-E)"
   V19449 = "B39 PRES EMP NOV90 (H-E)"
   V19450 = "B39 PRES EMP DEC90 (H-E)"
   V19451 = "B40 OTR EMP 1990  (HD-E)"
   V19452 = "B41 MO BEG OTR EMP  HD-E"
   V19453 = "B41 YR BEG OTR EMP  HD-E"
   V19454 = "B42 OTR EMP JAN90  (H-E)"
   V19455 = "B42 OTR EMP FEB90  (H-E)"
   V19456 = "B42 OTR EMP MAR90  (H-E)"
   V19457 = "B42 OTR EMP APR90  (H-E)"
   V19458 = "B42 OTR EMP MAY90  (H-E)"
   V19459 = "B42 OTR EMP JUN90  (H-E)"
   V19460 = "B42 OTR EMP JUL90  (H-E)"
   V19461 = "B42 OTR EMP AUG90  (H-E)"
   V19462 = "B42 OTR EMP SEP90  (H-E)"
   V19463 = "B42 OTR EMP OCT90  (H-E)"
   V19464 = "B42 OTR EMP NOV90  (H-E)"
   V19465 = "B42 OTR EMP DEC90  (H-E)"
   V19466 = "B43 WORK SELF/OTR?(HD-E)"
   V19467 = "B44 CORP/UNCORP BUS(H-E)"
   V19468 = "B45 WORK FOR GOVT?(HD-E)"
   V19469 = "B46-47 OCC OTR EMP (H-E)"
   V19470 = "B48 IND OTR EMP    (H-E)"
   V19471 = "B49 START WAGE OTR EMP H"
   V19472 = "B50 BEG HR/WK OTR EMP HD"
   V19473 = "B51 CHG POS OTR EMP(H-E)"
   V19474 = "B52 MO CHGE POS   (HD-E)"
   V19475 = "B53 TYPE CHG OTR EMP H-E"
   V19476 = "B54 STOP WRK OTR EMP H-E"
   V19477 = "B55 MO END OTR EMP (H-E)"
   V19478 = "B55 YR END OTR EMP (H-E)"
   V19479 = "B56 WHY LEFT OTR EMP H-E"
   V19480 = "B57 END WAGE OTR EMP H-E"
   V19481 = "B58 END HR/WK OTR EMP HD"
   V19482 = "B59 ANY OTR EMP 90 (H-E)"
   V19483 = "B-# WRK HIST SUPPS (H-E)"
   V19484 = "B60 WTR OTRS ILL  (HD-E)"
   V19485 = "B61 # WKS OTR ILL (HD-E)"
   V19486 = "B63 WTR SELF ILL  (HD-E)"
   V19487 = "B64 # WKS SELF ILL(HD-E)"
   V19488 = "B66 WTR VACATION  (HD-E)"
   V19489 = "B67 # WK VACATION (HD-E)"
   V19490 = "B69 WTR STRIKE    (HD-E)"
   V19491 = "B70 # WK ON STRIKE (H-E)"
   V19492 = "B72 WTR UNEMPLOYED(HD-E)"
   V19493 = "B73 # WK UNEMPLOYED(H-E)"
   V19494 = "B75 WTR OUT LAB FRC(H-E)"
   V19495 = "B76 #WK OUT LAB FRC(H-E)"
   V19496 = "B78 # WKS WORKED  (HD-E)"
   V19497 = "B79 # HR/WK WORKED (H-E)"
   V19498 = "B80 WTR WORKED OT (HD-E)"
   V19499 = "B82 WTR XTRA JOBS (HD-E)"
   V19500 = "B94-106 # XTRA JOBS(H-E)"
   V19501 = "B83 WORK FOR GOVT?(HD-E)"
   V19502 = "B84-85 OCC-XTRA JOB1 H-E"
   V19503 = "B86 IND XTRA JOB1  (H-E)"
   V19504 = "B87 PAY/HR XTRA JB1(H-E)"
   V19505 = "B88 # WKS XTRA JOB1(H-E)"
   V19506 = "B89 HR/WK XTRA JOB1(H-E)"
   V19507 = "B90 MO BEG XTRA JOB1 H-E"
   V19508 = "B90 YR BEG XTRA JOB1 H-E"
   V19509 = "B91 WRK XJB1 JAN90 (H-E)"
   V19510 = "B91 WRK XJB1 FEB90 (H-E)"
   V19511 = "B91 WRK XJB1 MAR90 (H-E)"
   V19512 = "B91 WRK XJB1 APR90 (H-E)"
   V19513 = "B91 WRK XJB1 MAY90 (H-E)"
   V19514 = "B91 WRK XJB1 JUN90 (H-E)"
   V19515 = "B91 WRK XJB1 JUL90 (H-E)"
   V19516 = "B91 WRK XJB1 AUG90 (H-E)"
   V19517 = "B91 WRK XJB1 SEP90 (H-E)"
   V19518 = "B91 WRK XJB1 OCT90 (H-E)"
   V19519 = "B91 WRK XJB1 NOV90 (H-E)"
   V19520 = "B91 WRK XJB1 DEC90 (H-E)"
   V19521 = "B92 STOP WRK XJOB1 (H-E)"
   V19522 = "B93 MO END XJOB1  (HD-E)"
   V19523 = "B93 YR END XJOB1  (HD-E)"
   V19524 = "B95 WRK FOR GOV XJB2 H-E"
   V19525 = "B95-97 OCC-XTRA JOB2 H-E"
   V19526 = "B98 IND XTRA JOB2  (H-E)"
   V19527 = "B99 AV PY/HR X JB2+(H-E)"
   V19528 = "B100 #WKS XTRA JB2+(H-E)"
   V19529 = "B101 AV HR/WK X JB2+ H-E"
   V19530 = "B102 MO BEG XJOB2  (H-E)"
   V19531 = "B102 YR BEG XJOB2  (H-E)"
   V19532 = "B103 WRK XJOB2 JAN90 H-E"
   V19533 = "B103 WRK XJOB2 FEB90 H-E"
   V19534 = "B103 WRK XJOB2 MAR90 H-E"
   V19535 = "B103 WRK XJOB2 APR90 H-E"
   V19536 = "B103 WRK XJOB2 MAY90 H-E"
   V19537 = "B103 WRK XJOB2 JUN90 H-E"
   V19538 = "B103 WRK XJOB2 JUL90 H-E"
   V19539 = "B103 WRK XJOB2 AUG90 H-E"
   V19540 = "B103 WRK XJOB2 SEP90 H-E"
   V19541 = "B103 WRK XJOB2 OCT90 H-E"
   V19542 = "B103 WRK XJOB2 NOV90 H-E"
   V19543 = "B103 WRK XJOB2 DEC90 H-E"
   V19544 = "B104 STOP WORK XJOB2 H-E"
   V19545 = "B105 MO END XJOB2 (HD-E)"
   V19546 = "B105 YR END XJOB2 (HD-E)"
   V19547 = "C1 WTR LOOK FOR JOB(H-U)"
   V19548 = "C2 DONE NOTHING   (HD-U)"
   V19549 = "C2 PUBLIC EMP AGCY (H-U)"
   V19550 = "C2 PRIVATE EMP AGY (H-U)"
   V19551 = "C2 PREV EMP DIRECT (H-U)"
   V19552 = "C2 OTR EMPR DIRECT (H-U)"
   V19553 = "C2 FRIEND OR REL   (H-U)"
   V19554 = "C2 PLACE OR ANS AD (H-U)"
   V19555 = "C2 OTHER           (H-U)"
   V19556 = "C3 HOW LONG LOOK WRK H-U"
   V19557 = "C4 EVER WORKED?   (HD-U)"
   V19558 = "C5 MO LAST WORKED (HD-U)"
   V19559 = "C5 YR LAST WORKED (HD-U)"
   V19560 = "C6 WTR UNEMP 90    (H-U)"
   V19561 = "C7 # WK UNEMP 90   (H-U)"
   V19562 = "C9-10 OCC-LAST JOB (H-U)"
   V19563 = "C11 IND-LAST JOB  (HD-U)"
   V19564 = "C12 WRK SELF/OTR? (HD-U)"
   V19565 = "C13 CORP/UNCORP BUS(H-U)"
   V19566 = "C14 WORK FOR GOVT? (H-U)"
   V19567 = "C15 WHY LAST JOB END H-U"
   V19568 = "C16 MO BEG LAST EMP  H-U"
   V19569 = "C16 YR BEG LAST EMP  H-U"
   V19570 = "C17 BEG WK LAST POS(H-U)"
   V19571 = "C18 MO BEG LAST POS  H-U"
   V19572 = "C18 YR BEG LAST POS  H-U"
   V19573 = "C19 CHGE POS IN 90(HD-U)"
   V19574 = "C20 MO CHGE POS   (HD-U)"
   V19575 = "C21 TYPE OF CHGE  (HD-U)"
   V19576 = "C22 MO BEG LAST POS(H-U)"
   V19577 = "C22 YR BEG LAST POS(H-U)"
   V19578 = "C23 MO BEG LAST POS(H-U)"
   V19579 = "C23 YR BEG LAST POS(H-U)"
   V19580 = "C24 CHGE POS IN 90(HD-U)"
   V19581 = "C25 MO CHGE POS   (HD-U)"
   V19582 = "C26 TYPE OF CHGE  (HD-U)"
   V19583 = "C27-28 BEG OCC LAST EMP"
   V19584 = "C29 WAGE BEG LAST EMP HD"
   V19585 = "C30 HR/WK BEG LAST EMP H"
   V19586 = "C31 LAST EMP JAN90 (H-U)"
   V19587 = "C31 LAST EMP FEB90 (H-U)"
   V19588 = "C31 LAST EMP MAR90 (H-U)"
   V19589 = "C31 LAST EMP APR90 (H-U)"
   V19590 = "C31 LAST EMP MAY90 (H-U)"
   V19591 = "C31 LAST EMP JUN90 (H-U)"
   V19592 = "C31 LAST EMP JUL90 (H-U)"
   V19593 = "C31 LAST EMP AUG90 (H-U)"
   V19594 = "C31 LAST EMP SEP90 (H-U)"
   V19595 = "C31 LAST EMP OCT90 (H-U)"
   V19596 = "C31 LAST EMP NOV90 (H-U)"
   V19597 = "C31 LAST EMP DEC90 (H-U)"
   V19598 = "C32 OTR EMP 1990  (HD-U)"
   V19599 = "C33 MO BEG OTR EMP(HD-U)"
   V19600 = "C33 YR BEG OTR EMP(HD-U)"
   V19601 = "C34 OTR EMP JAN90  (H-U)"
   V19602 = "C34 OTR EMP FEB90  (H-U)"
   V19603 = "C34 OTR EMP MAR90  (H-U)"
   V19604 = "C34 OTR EMP APR90  (H-U)"
   V19605 = "C34 OTR EMP MAY90  (H-U)"
   V19606 = "C34 OTR EMP JUN90  (H-U)"
   V19607 = "C34 OTR EMP JUL90  (H-U)"
   V19608 = "C34 OTR EMP AUG90  (H-U)"
   V19609 = "C34 OTR EMP SEP90  (H-U)"
   V19610 = "C34 OTR EMP OCT90  (H-U)"
   V19611 = "C34 OTR EMP NOV90  (H-U)"
   V19612 = "C34 OTR EMP DEC90  (H-U)"
   V19613 = "C35 WORK SELF/OTR?(HD-U)"
   V19614 = "C36 CORP/UNCORP BUS(H-U)"
   V19615 = "C37 WRK GOV-OTR EMP? H-U"
   V19616 = "C38-39 OCC OTR EMP (H-U)"
   V19617 = "C40 IND OTR EMP   (HD-U)"
   V19618 = "C41 START WAGE OTR EMP H"
   V19619 = "C42 BEG HR/WK OTR EMP HD"
   V19620 = "C43 CHG POS OTR EMP(H-U)"
   V19621 = "C44 MO CHGE POS   (HD-U)"
   V19622 = "C45 TYPE CHG OTR EMP H-U"
   V19623 = "C46 STOP WRK OTR EMP H-U"
   V19624 = "C47 MO END OTR EMP  HD-U"
   V19625 = "C47 YR END OTR EMP  HD-U"
   V19626 = "C48 WHY LEFT OTR EMP H-U"
   V19627 = "C49 END WAGE OTR EMP H-U"
   V19628 = "C50 END HRS/WK OTR EMP H"
   V19629 = "C51 ANY OTR EMP 90 (H-U)"
   V19630 = "C-# WORK HIST SUPPS(H-U)"
   V19631 = "C52 WTR VACATION  (HD-U)"
   V19632 = "C53 #WKS VACATION (HD-U)"
   V19633 = "C55 WTR OTRS ILL  (HD-U)"
   V19634 = "C56 #WKS OTRS ILL (HD-U)"
   V19635 = "C58 WTR SELF ILL  (HD-U)"
   V19636 = "C59 #WKS SELF ILL (HD-U)"
   V19637 = "C61 WTR ON STRIKE (HD-U)"
   V19638 = "C62 #WKS ON STRIKE (H-U)"
   V19639 = "C64 WTR UNEMPLOYED (H-U)"
   V19640 = "C65 #WK UNEMPLOYED (H-U)"
   V19641 = "C67 WTR OUT LAB FRC(H-U)"
   V19642 = "C68 #WKS OUT LAB FRC H-U"
   V19643 = "C70 # WKS WORKED  (HD-U)"
   V19644 = "C71 HR/WK WORKED  (HD-U)"
   V19645 = "C72 WTR WORKED OT (HD-U)"
   V19646 = "C74 WTR XTRA JOBS (HD-U)"
   V19647 = "C74-98 # XTRA JOBS (H-U)"
   V19648 = "C75 WORK FOR GOVT?(HD-U)"
   V19649 = "C76-77 OCC-XTRA JOB1 H-U"
   V19650 = "C78 IND XTRA JOB1 (HD-U)"
   V19651 = "C79 PAY/HR XTRA JOB1 H-U"
   V19652 = "C80 # WKS EXTRA JOB1 H-U"
   V19653 = "C81 HR/WK XTRA JOB1(H-U)"
   V19654 = "C82 MO BEG XTRA JOB1 H-U"
   V19655 = "C82 YR BEG XTRA JOB1 H-U"
   V19656 = "C83 WRK XJOB1 JAN90  H-U"
   V19657 = "C83 WRK XJOB1 FEB90  H-U"
   V19658 = "C83 WRK XJOB1 MAR90  H-U"
   V19659 = "C83 WRK XJOB1 APR90  H-U"
   V19660 = "C83 WRK XJOB1 MAY90  H-U"
   V19661 = "C83 WRK XJOB1 JUN90  H-U"
   V19662 = "C83 WRK XJOB1 JUL90  H-U"
   V19663 = "C83 WRK XJOB1 AUG90  H-U"
   V19664 = "C83 WRK XJOB1 SEP90  H-U"
   V19665 = "C83 WRK XJOB1 OCT90  H-U"
   V19666 = "C83 WRK XJOB1 NOV90  H-U"
   V19667 = "C83 WRK XJOB1 DEC90  H-U"
   V19668 = "C84 STOP WORK XJOB1 H-U"
   V19669 = "C85 MO END XJOB1  (HD-U)"
   V19670 = "C85 YR END XJOB1  (HD-U)"
   V19671 = "C87 WRK FOR GOV XJB2 H-U"
   V19672 = "C88-89 OCC-XTRA JB2(H-U)"
   V19673 = "C90 IND XTRA JOB2  (H-U)"
   V19674 = "C91 AV PY/HR X JB2+(H-U)"
   V19675 = "C92 # WK XTRA JOB2+(H-U)"
   V19676 = "C93 AV HR/WK X JB2+(H-U)"
   V19677 = "C94 MO BEG XJOB2   (H-U)"
   V19678 = "C94 YR BEG XJOB2   (H-U)"
   V19679 = "C95 WRK XJOB2 JAN90  H-U"
   V19680 = "C95 WRK XJOB2 FEB90  H-U"
   V19681 = "C95 WRK XJOB2 MAR90  H-U"
   V19682 = "C95 WRK XJOB2 APR90  H-U"
   V19683 = "C95 WRK XJOB2 MAY90  H-U"
   V19684 = "C95 WRK XJOB2 JUN90  H-U"
   V19685 = "C95 WRK XJOB2 JUL90  H-U"
   V19686 = "C95 WRK XJOB2 AUG90  H-U"
   V19687 = "C95 WRK XJOB2 SEP90  H-U"
   V19688 = "C95 WRK XJOB2 OCT90  H-U"
   V19689 = "C95 WRK XJOB2 NOV90  H-U"
   V19690 = "C95 WRK XJOB2 DEC90  H-U"
   V19691 = "C96 STOP WORK XJOB2 H-U"
   V19692 = "C97 MO END JOB2   (HD-U)"
   V19693 = "C97 YR END JOB2   (HD-U)"
   V19694 = "D1 CHKPT"
   V19695 = "D1A EMPLOYMENT STATUS-WF"
   V19696 = "D2 YEAR RETIRED   (WF-R)"
   V19697 = "D3 WORK FOR MONEY?(WF-E)"
   V19698 = "D4 WORK SELF/OTR? (WF-E)"
   V19699 = "D5 CORP/UNCORP BUS(WF-E)"
   V19700 = "D6 WORK FOR GOVT? (WF-E)"
   V19701 = "D7 JOB NOW UNION?  (W-E)"
   V19702 = "D8 BELONG UNION?  (WF-E)"
   V19703 = "D9-10 MAIN OCC:3 DIG W-E"
   V19704 = "D11 MAIN IND:3 DIGT(W-E)"
   V19705 = "D12 SLRY/HRLY/OTR  (W-E)"
   V19706 = "D13 PAY/HR-SALARY (WF-E)"
   V19707 = "D14 WTR SAL PD OT (WF-E)"
   V19708 = "D15 PAY/HR-SLRYOT (WF-E)"
   V19709 = "D16 PAY/HR-HOURLY (WF-E)"
   V19710 = "D17 PAY/HR-HRLY OT (W-E)"
   V19711 = "D18 HOW PAID-OTR  (WF-E)"
   V19712 = "D19 PAY/HR-OTR OT  (W-E)"
   V19713 = "D20 GET NEW JOB?  (WF-E)"
   V19714 = "D21 DONE NOTHING   (W-E)"
   V19715 = "D21 PUBLIC EMP AGCY(W-E)"
   V19716 = "D21 PRIVATE EMP AGY(W-E)"
   V19717 = "D21 PRES EMP DIRECT(W-E)"
   V19718 = "D21 OTR EMPR DIRECT(W-E)"
   V19719 = "D21 FRIEND OR REL  (W-E)"
   V19720 = "D21 PLACE OR ANS AD(W-E)"
   V19721 = "D21 OTHER          (W-E)"
   V19722 = "D23 #MO PRESENT EMP(W-E)"
   V19723 = "D24 MO BEG PRES EMP(W-E)"
   V19724 = "D24 YR BEG PRES EMP(W-E)"
   V19725 = "D25 BEG WRK PRES POS W-E"
   V19726 = "D26 MO BEG PRES POS(W-E)"
   V19727 = "D26 YR BEG PRES POS(W-E)"
   V19728 = "D27 CHGE POS IN 90(WF-E)"
   V19729 = "D28 MO CHGE POS   (WF-E)"
   V19730 = "D29 TYPE OF CHGE  (WF-E)"
   V19731 = "D30 MO BEG PRES POS(W-E)"
   V19732 = "D30 YR BEG PRES POS(W-E)"
   V19733 = "D31 MO BEG PRES POS(W-E)"
   V19734 = "D31 YR BEG PRES POS(W-E)"
   V19735 = "D32 CHGE POS IN 90(WF-E)"
   V19736 = "D33 MO CHGE POS   (WF-E)"
   V19737 = "D34 TYPE OF CHGE  (WF-E)"
   V19738 = "D35-6 BEG OCC PRES EMP-W"
   V19739 = "D37 STARTING WAGE  (W-E)"
   V19740 = "D38 STARTING HR/WK (W-E)"
   V19741 = "D39 PRES EMP JAN90 (W-E)"
   V19742 = "D39 PRES EMP FEB90 (W-E)"
   V19743 = "D39 PRES EMP MAR90 (W-E)"
   V19744 = "D39 PRES EMP APR90 (W-E)"
   V19745 = "D39 PRES EMP MAY90 (W-E)"
   V19746 = "D39 PRES EMP JUN90 (W-E)"
   V19747 = "D39 PRES EMP JUL90 (W-E)"
   V19748 = "D39 PRES EMP AUG90 (W-E)"
   V19749 = "D39 PRES EMP SEP90 (W-E)"
   V19750 = "D39 PRES EMP OCT90 (W-E)"
   V19751 = "D39 PRES EMP NOV90 (W-E)"
   V19752 = "D39 PRES EMP DEC90 (W-E)"
   V19753 = "D40 OTR EMP 1990  (WF-E)"
   V19754 = "D41 MO BEG OTR EMP(WF-E)"
   V19755 = "D41 YR BEG OTR EMP(WF-E)"
   V19756 = "D42 OTR EMP JAN90  (W-E)"
   V19757 = "D42 OTR EMP FEB90  (W-E)"
   V19758 = "D42 OTR EMP MAR90  (W-E)"
   V19759 = "D42 OTR EMP APR90  (W-E)"
   V19760 = "D42 OTR EMP MAY90  (W-E)"
   V19761 = "D42 OTR EMP JUN90  (W-E)"
   V19762 = "D42 OTR EMP JUL90  (W-E)"
   V19763 = "D42 OTR EMP AUG90  (W-E)"
   V19764 = "D42 OTR EMP SEP90  (W-E)"
   V19765 = "D42 OTR EMP OCT90  (W-E)"
   V19766 = "D42 OTR EMP NOV90  (W-E)"
   V19767 = "D42 OTR EMP DEC90  (W-E)"
   V19768 = "D43 WORK SELF/OTR?(WF-E)"
   V19769 = "D44 CORP/UNCORP BUS(W-E)"
   V19770 = "D45 WORK GOV-OTR EMP?-WF"
   V19771 = "D46-47 OCC OTR EMP (W-E)"
   V19772 = "D48 IND OTR EMP    (W-E)"
   V19773 = "D49 START WAGE OTR EMP W"
   V19774 = "D50 BEG HR/WK OTR EMP WF"
   V19775 = "D51 CHG POS OTR EMP(W-E)"
   V19776 = "D52 MO CHGE POS   (WF-E)"
   V19777 = "D53 TYPE CHG OTR EMP W-E"
   V19778 = "D54 STOP WRK OTR EMP W-E"
   V19779 = "D55 MO END OTR EMP (W-E)"
   V19780 = "D55 YR END OTR EMP (W-E)"
   V19781 = "D56 WHY LEFT OTR EMP W-E"
   V19782 = "D57 END WAGE OTR EMP W-E"
   V19783 = "D58 END HR/WK OTR EMP WF"
   V19784 = "D59 ANY OTR EMP 90 (W-E)"
   V19785 = "D-# WRK HIST SUPPS (W-E)"
   V19786 = "D60 WTR OTRS ILL  (WF-E)"
   V19787 = "D61 # WKS OTR ILL (WF-E)"
   V19788 = "D63 WTR SELF ILL  (WF-E)"
   V19789 = "D64 # WKS SELF ILL(WF-E)"
   V19790 = "D66 WTR VACATION  (WF-E)"
   V19791 = "D67 # WK VACATION (WF-E)"
   V19792 = "D69 WTR STRIKE    (WF-E)"
   V19793 = "D70 # WK ON STRIKE (W-E)"
   V19794 = "D72 WTR UNEMPLOYED(WF-E)"
   V19795 = "D73 # WK UNEMPLOYED(W-E)"
   V19796 = "D75 WTR OUT LAB FRC(W-E)"
   V19797 = "D76 #WK OUT LAB FRC(W-E)"
   V19798 = "D78 # WKS WORKED  (WF-E)"
   V19799 = "D79 # HR/WK WORKED (W-E)"
   V19800 = "D80 WTR WORKED OT (WF-E)"
   V19801 = "D82 WTR XTRA JOBS (WF-E)"
   V19802 = "D82-106 # XTRA JOBS(W-E)"
   V19803 = "D83 WORK FOR GOVT?(WF-E)"
   V19804 = "D84-85 OCC-XTRA JOB1 W-E"
   V19805 = "D86 IND XTRA JOB1  (W-E)"
   V19806 = "D87 PAY/HR XTRA JB1(W-E)"
   V19807 = "D88 # WKS XTRA JOB1(W-E)"
   V19808 = "D89 HR/WK XTRA JOB1(W-E)"
   V19809 = "D90 MO BEG XTRA JOB1 W-E"
   V19810 = "D90 YR BEG XTRA JOB1 W-E"
   V19811 = "D91 WRK XJB1 JAN90 (W-E)"
   V19812 = "D91 WRK XJB1 FEB90 (W-E)"
   V19813 = "D91 WRK XJB1 MAR90 (W-E)"
   V19814 = "D91 WRK XJB1 APR90 (W-E)"
   V19815 = "D91 WRK XJB1 MAY90 (W-E)"
   V19816 = "D91 WRK XJB1 JUN90 (W-E)"
   V19817 = "D91 WRK XJB1 JUL90 (W-E)"
   V19818 = "D91 WRK XJB1 AUG90 (W-E)"
   V19819 = "D91 WRK XJB1 SEP90 (W-E)"
   V19820 = "D91 WRK XJB1 OCT90 (W-E)"
   V19821 = "D91 WRK XJB1 NOV90 (W-E)"
   V19822 = "D91 WRK XJB1 DEC90 (W-E)"
   V19823 = "D92 STOP WRK XJOB1 (W-E)"
   V19824 = "D93 MO END XJOB1  (WF-E)"
   V19825 = "D93 YR END XJOB1  (WF-E)"
   V19826 = "D95 WRK FOR GOV XJB2 W-E"
   V19827 = "D95-97 OCC-XTRA JOB2 W-E"
   V19828 = "D98 IND XTRA JOB2  (W-E)"
   V19829 = "D99 AV PY/HR X JB2+(W-E)"
   V19830 = "D100 #WKS XTRA JB2+(W-E)"
   V19831 = "D101 AV HR/WK X JB2+ W-E"
   V19832 = "D102 MO BEG XJOB2  (W-E)"
   V19833 = "D102 YR BEG XJOB2  (W-E)"
   V19834 = "D103 WRK XJOB2 JAN90 W-E"
   V19835 = "D103 WRK XJOB2 FEB90 W-E"
   V19836 = "D103 WRK XJOB2 MAR90 W-E"
   V19837 = "D103 WRK XJOB2 APR90 W-E"
   V19838 = "D103 WRK XJOB2 MAY90 W-E"
   V19839 = "D103 WRK XJOB2 JUN90 W-E"
   V19840 = "D103 WRK XJOB2 JUL90 W-E"
   V19841 = "D103 WRK XJOB2 AUG90 W-E"
   V19842 = "D103 WRK XJOB2 SEP90 W-E"
   V19843 = "D103 WRK XJOB2 OCT90 W-E"
   V19844 = "D103 WRK XJOB2 NOV90 W-E"
   V19845 = "D103 WRK XJOB2 DEC90 W-E"
   V19846 = "D104 STOP WRK XJOB2 W-E"
   V19847 = "D105 MO END XJOB2 (WF-E)"
   V19848 = "D105 YR END XJOB2 (WF-E)"
   V19849 = "E1 WTR LOOK FOR JOB(W-U)"
   V19850 = "E2 DONE NOTHING   (WF-U)"
   V19851 = "E2 PUBLIC EMP AGCY (W-U)"
   V19852 = "E2 PRIVATE EMP AGY (W-U)"
   V19853 = "E2 PREV EMP DIRECT (W-U)"
   V19854 = "E2 OTR EMPR DIRECT (W-U)"
   V19855 = "E2 FRIEND OR REL   (W-U)"
   V19856 = "E2 PLACE OR ANS AD (W-U)"
   V19857 = "E2 OTHER           (W-U)"
   V19858 = "E3 HOW LONG LOOK WRK W-U"
   V19859 = "E4 EVER WORKED?   (WF-U)"
   V19860 = "E5 MO LAST WORKED (WF-U)"
   V19861 = "E5 YR LAST WORKED (WF-U)"
   V19862 = "E6 WTR UNEMP 90    (W-U)"
   V19863 = "E7 # WK UNEMP 90   (W-U)"
   V19864 = "E9-10 OCC-LAST JOB (W-U)"
   V19865 = "E11 IND-LAST JOB  (WF-U)"
   V19866 = "E12 WRK SELF/OTR? (WF-U)"
   V19867 = "E13 CORP/UNCORP BUS(W-U)"
   V19868 = "E14 WORK FOR GOVT? (W-U)"
   V19869 = "E15 WHY LAST JOB END W-U"
   V19870 = "E16 MO BEG LAST EMP  W-U"
   V19871 = "E16 YR BEG LAST EMP  W-U"
   V19872 = "E17 BEG WK LAST POS(W-U)"
   V19873 = "E18 MO BEG LAST POS(W-U)"
   V19874 = "E18 YR BEG LAST POS(W-U)"
   V19875 = "E19 CHGE POS IN 90(WF-U)"
   V19876 = "E20 MO CHGE POS   (WF-U)"
   V19877 = "E21 TYPE OF CHGE  (WF-U)"
   V19878 = "E22 MO BEG LAST POS(W-U)"
   V19879 = "E22 YR BEG LAST POS(W-U)"
   V19880 = "E23 MO BEG LAST POS(W-U)"
   V19881 = "E23 YR BEG LAST POS(W-U)"
   V19882 = "E24 CHGE POS IN 90(WF-U)"
   V19883 = "E25 MO CHGE POS   (WF-U)"
   V19884 = "E26 TYPE OF CHGE  (WF-U)"
   V19885 = "E27-8 BEG OCC LAST EMP-W"
   V19886 = "E29 WAGE BEG LAST EMP-WF"
   V19887 = "E30 HR/WK BEG LAST EMP-W"
   V19888 = "E31 LAST EMP JAN90 (W-U)"
   V19889 = "E31 LAST EMP FEB90 (W-U)"
   V19890 = "E31 LAST EMP MAR90 (W-U)"
   V19891 = "E31 LAST EMP APR90 (W-U)"
   V19892 = "E31 LAST EMP MAY90 (W-U)"
   V19893 = "E31 LAST EMP JUN90 (W-U)"
   V19894 = "E31 LAST EMP JUL90 (W-U)"
   V19895 = "E31 LAST EMP AUG90 (W-U)"
   V19896 = "E31 LAST EMP SEP90 (W-U)"
   V19897 = "E31 LAST EMP OCT90 (W-U)"
   V19898 = "E31 LAST EMP NOV90 (W-U)"
   V19899 = "E31 LAST EMP DEC90 (W-U)"
   V19900 = "E32 OTR EMP 1990  (WF-U)"
   V19901 = "E33 MO BEG OTR EMP(WF-U)"
   V19902 = "E33 YR BEG OTR EMP(WF-U)"
   V19903 = "E34 OTR EMP JAN90  (W-U)"
   V19904 = "E34 OTR EMP FEB90  (W-U)"
   V19905 = "E34 OTR EMP MAR90  (W-U)"
   V19906 = "E34 OTR EMP APR90  (W-U)"
   V19907 = "E34 OTR EMP MAY90  (W-U)"
   V19908 = "E34 OTR EMP JUN90  (W-U)"
   V19909 = "E34 OTR EMP JUL90  (W-U)"
   V19910 = "E34 OTR EMP AUG90  (W-U)"
   V19911 = "E34 OTR EMP SEP90  (W-U)"
   V19912 = "E34 OTR EMP OCT90  (W-U)"
   V19913 = "E34 OTR EMP NOV90  (W-U)"
   V19914 = "E34 OTR EMP DEC90  (W-U)"
   V19915 = "E35 WORK SELF/OTR?(WF-U)"
   V19916 = "E36 CORP/UNCORP BUS(W-U)"
   V19917 = "E37 WRK GOV-OTR EMP? W-U"
   V19918 = "E38-39 OCC OTR EMP (W-U)"
   V19919 = "E40 IND OTR EMP   (WF-U)"
   V19920 = "E41 START WAGE OTR EMP-W"
   V19921 = "E42 BEG HR/WK OTR EMP-WF"
   V19922 = "E43 CHG POS OTR EMP(W-U)"
   V19923 = "E44 MO CHGE POS   (WF-U)"
   V19924 = "E45 TYPE CHG OTR EMP W-U"
   V19925 = "E46 STOP WRK OTR EMP W-U"
   V19926 = "E47 MO END OTR EMP(WF-U)"
   V19927 = "E47 YR END OTR EMP(WF-U)"
   V19928 = "E48 WHY LEFT OTR EMP W-U"
   V19929 = "E49 END WAGE OTR EMP W-U"
   V19930 = "E50 END HR/WK OTR EMP-WF"
   V19931 = "E51 ANY OTR EMP 90 (W-U)"
   V19932 = "E-# WORK HIST SUPPS(W-U)"
   V19933 = "E52 WTR VACATION  (WF-U)"
   V19934 = "E53 #WKS VACATION (WF-U)"
   V19935 = "E55 WTR OTRS ILL  (WF-U)"
   V19936 = "E56 #WKS OTRS ILL (WF-U)"
   V19937 = "E58 WTR SELF ILL  (WF-U)"
   V19938 = "E59 #WKS SELF ILL (WF-U)"
   V19939 = "E61 WTR ON STRIKE (WF-U)"
   V19940 = "E62 #WKS ON STRIKE (W-U)"
   V19941 = "E64 WTR UNEMPLOYED (W-U)"
   V19942 = "E65 #WK UNEMPLOYED (W-U)"
   V19943 = "E67 WTR OUT LAB FRC(W-U)"
   V19944 = "E68 #WKS OUT LAB FRC W-U"
   V19945 = "E70 # WKS WORKED  (WF-U)"
   V19946 = "E71 HR/WK WORKED  (WF-U)"
   V19947 = "E72 WTR WORKED OT (WF-U)"
   V19948 = "E74 WTR XTRA JOBS (WF-U)"
   V19949 = "E74-98 # XTRA JOBS (W-U)"
   V19950 = "E75 WORK FOR GOVT?(WF-U)"
   V19951 = "E76-77 OCC-XTRA JOB1 W-U"
   V19952 = "E78 IND XTRA JOB1 (WF-U)"
   V19953 = "E79 PAY/HR XTRA JOB1 W-U"
   V19954 = "E80 # WKS EXTRA JOB1 W-U"
   V19955 = "E81 HR/WK XTRA JOB1(W-U)"
   V19956 = "E82 MO BEG XTRA JOB1 W-U"
   V19957 = "E82 YR BEG XTRA JOB1 W-U"
   V19958 = "E83 WRK XJOB1 JAN90  W-U"
   V19959 = "E83 WRK XJOB1 FEB90  W-U"
   V19960 = "E83 WRK XJOB1 MAR90  W-U"
   V19961 = "E83 WRK XJOB1 APR90  W-U"
   V19962 = "E83 WRK XJOB1 MAY90  W-U"
   V19963 = "E83 WRK XJOB1 JUN90  W-U"
   V19964 = "E83 WRK XJOB1 JUL90  W-U"
   V19965 = "E83 WRK XJOB1 AUG90  W-U"
   V19966 = "E83 WRK XJOB1 SEP90  W-U"
   V19967 = "E83 WRK XJOB1 OCT90  W-U"
   V19968 = "E83 WRK XJOB1 NOV90  W-U"
   V19969 = "E83 WRK XJOB1 DEC90  W-U"
   V19970 = "E84 STOP WORK XJOB1  W-U"
   V19971 = "E85 MO END XJOB1  (WF-U)"
   V19972 = "E85 YR END XJOB1  (WF-U)"
   V19973 = "E87 WRK FOR GOV XJB2 W-U"
   V19974 = "E88-89 OCC-XTRA JB2(W-U)"
   V19975 = "E90 IND XTRA JOB2  (W-U)"
   V19976 = "E91 AV PY/HR X JB2+(W-U)"
   V19977 = "E92 # WK XTRA JOB2+(W-U)"
   V19978 = "E93 AV HR/WK X JB2+(W-U)"
   V19979 = "E94 MO BEG XJOB2   (W-U)"
   V19980 = "E94 YR BEG XJOB2   (W-U)"
   V19981 = "E95 WRK XJOB2 JAN90  W-U"
   V19982 = "E95 WRK XJOB2 FEB90  W-U"
   V19983 = "E95 WRK XJOB2 MAR90  W-U"
   V19984 = "E95 WRK XJOB2 APR90  W-U"
   V19985 = "E95 WRK XJOB2 MAY90  W-U"
   V19986 = "E95 WRK XJOB2 JUN90  W-U"
   V19987 = "E95 WRK XJOB2 JUL90  W-U"
   V19988 = "E95 WRK XJOB2 AUG90  W-U"
   V19989 = "E95 WRK XJOB2 SEP90  W-U"
   V19990 = "E95 WRK XJOB2 OCT90  W-U"
   V19991 = "E95 WRK XJOB2 NOV90  W-U"
   V19992 = "E95 WRK XJOB2 DEC90  W-U"
   V19993 = "E96 STOP WORK XJOB2 W-U"
   V19994 = "E97 MO END JOB2   (WF-U)"
   V19995 = "E97 YR END JOB2   (WF-U)"
   V19996 = "F1 CKPT:TYPE HEAD+WIFE"
   V19997 = "F2 HOUSEWORK HRS-WIFE"
   V19998 = "F3 HOUSEWORK HOURS-HEAD"
   V19999 = "F5 FAM TOGETHR MAIN MEAL"
   V20000 = "F7 COST CHILD CARE 1990"
   V20001 = "G2 WHETHER HEAD FARMER"
   V20002 = "G3 TOTAL FARM RECEIPTS"
   V20003 = "G6 WHETHER BUSINESS"
   V20004 = "G7 TYPE BUS HAVE INT IN"
   V20005 = "G8 WHO IN FAM OWNED BUS"
   V20006 = "G9 R PUT TIME IN BUS 90?"
   V20007 = "G10 CORP/UNINCORP BUS"
   V20008 = "G99 WTR LUMP SUM PAYMNTS"
   V20009 = "G100 LUMP SUM PAYMNTS"
   V20010 = "G101 INHERITANCE"
   V20011 = "G102 WTR ITEM 90 TAX DED"
   V20012 = "G103 WTR HELP SUPPORT OT"
   V20013 = "G104 # OTRS SUPPORTED"
   V20014 = "G105 WHO SUPPORTED 1"
   V20015 = "G105 WHO SUPPORTED 2"
   V20016 = "G105 WHO SUPPORTED 3"
   V20017 = "G107 ANY CHILD SUPPORT"
   V20018 = "G109 ANY ALIMONY"
   V20019 = "G112-4 WTR DEPENDNT OTRS"
   V20020 = "G113 # OTR DEPENDENTS"
   V20021 = "H1 STATUS OF HEALTH-HEAD"
   V20022 = "H2 LIMIT TYPE/AMT WRK  H"
   V20023 = "H3 NOT DO CERTAIN WRK  H"
   V20024 = "H4 LIMIT AMT WRK DO    H"
   V20025 = "H5 ANY REC MED AID? 90"
   V20026 = "H7 IWCKPT-W/'W' IN FU?"
   V20027 = "H8 STATUS OF HLTH-WIFE"
   V20028 = "H9 LIMIT TYPE/AMT WRK W"
   V20029 = "H10 NOT DO CERTAIN WRK W"
   V20030 = "H11 LIMIT AMT WORK DO  W"
   V20031 = "H12 IWCKPT:OTHER IN FU"
   V20032 = "H13 HEALTH STATUS OFUM"
   V20033 = "K1 CKPT: WTR WIFE"
   V20034 = "K2-3 EDUC OF FATHER   WF"
   V20035 = "K4-5 EDUC OF MOTHER   WF"
   V20036 = "K6 WHETHER BROTHERS   WF"
   V20037 = "K7 # BROTHERS       WIFE"
   V20038 = "K8 ONLY BRO STILL ALIVE"
   V20039 = "K9 ONLY BRO OLDR THAN W"
   V20040 = "K10 # BRO STILL ALIVE"
   V20041 = "K11 ANY BRO OLDR THAN WF"
   V20042 = "K12 WHETHER SISTERS   WF"
   V20043 = "K13 # SISTERS       WIFE"
   V20044 = "K14 ONLY SIS STILL ALIVE"
   V20045 = "K15 ONLY SIS OLDR THAN W"
   V20046 = "K16 # SIS STILL ALIVE"
   V20047 = "K17 ANY SIS OLDR THAN WF"
   V20048 = "K18 SPANISH DESCENT   WF"
   V20049 = "K19 RACE OF WIFE 1"
   V20050 = "K19 RACE OF WIFE 2"
   V20051 = "K20 WTR IN MILIT SERV  W"
   V20052 = "K21 WTR GRADUATED HS  WF"
   V20053 = "K22 YR GRADUATED HS   WF"
   V20054 = "K23 GRADE LEVEL IF GED W"
   V20055 = "K24 YR LAST IN SCH-GED W"
   V20056 = "K25 YR RECEIVED GED   WF"
   V20057 = "K26 GRD OF SCH FINISH  W"
   V20058 = "K27 YR LAST IN SCH-NONGR"
   V20059 = "K28 WTR ATTEND COLLEGE W"
   V20060 = "K29 YR LAST ATTEND COLL"
   V20061 = "K30 HGHST YR COLL COMP W"
   V20062 = "K31 WTR RECD COLL DEG  W"
   V20063 = "K32 HGHST COLL DEG REC W"
   V20064 = "K35 YR RECD COLL DEG   W"
   V20065 = "K36 WTR REC OTR DEG/CERT"
   V20066 = "K36 # OTR DEG/CERT REC"
   V20067 = "K37 TYPE OTR DEG/CERT 1"
   V20068 = "K38 FIELD OF DEG/CERT 1"
   V20069 = "K39 INST/ORG DEG/CERT 1"
   V20070 = "K40 YR REC DEG/CERT 1"
   V20071 = "K37 TYPE OTR DEG/CERT 2"
   V20072 = "K38 FIELD OF DEG/CERT 2"
   V20073 = "K39 INST/ORG DEG/CERT 2"
   V20074 = "K40 YR REC DEG/CERT 2"
   V20075 = "K37 TYPE OTR DEG/CERT 3"
   V20076 = "K38 FIELD OF DEG/CERT 3"
   V20077 = "K39 INST/ORG DEG/CERT 3"
   V20078 = "K40 YR REC DEG/CERT 3"
   V20079 = "K42-43 RELIGIOUS PREF  W"
   V20080 = "K44 #YRS WRKD SINCE 18 W"
   V20081 = "K45 #YR WRKD FULL-TIME W"
   V20082 = "L1 CKPT: WTR NEW HEAD"
   V20083 = "L2 STATE FA GREW UP   HD"
   V20084 = "L2 CNTY FA GREW UP    HD"
   V20085 = "L3 STATE MO GREW UP   HD"
   V20086 = "L3 CNTY MO GREW UP    HD"
   V20087 = "L4 OCCUPATION OF FA   HD"
   V20088 = "L5 FIRST OCCUPATION   HD"
   V20089 = "L6 # DIFF JOBS OR?    HD"
   V20090 = "L7 GREW UP FARM OR?   HD"
   V20091 = "L8-9 STATE GREW UP    HD"
   V20092 = "L8-9 CNTY GREW UP     HD"
   V20093 = "L8-10 #REGIONS LIVED  HD"
   V20094 = "L8-10 #STATES LIVED   HD"
   V20095 = "L11 EVER MOVE FOR JOB? H"
   V20096 = "L12 NOT MOVED FOR JOB? H"
   V20097 = "L13 PARENTS POOR OR?  HD"
   V20098 = "L14-15 EDUC OF FATHER  H"
   V20099 = "L16-17 EDUC OF MOTHER  H"
   V20100 = "L18 WHETHER BROTHERS  HD"
   V20101 = "L19 # BROTHERS      HEAD"
   V20102 = "L20 ONLY BRO STILL ALIVE"
   V20103 = "L21 ONLY BRO OLDR THAN H"
   V20104 = "L22 # BRO STILL ALIVE"
   V20105 = "L23 ANY BRO OLDR THAN H"
   V20106 = "L24 WHETHER SISTERS   HD"
   V20107 = "L25 # SISTERS       HEAD"
   V20108 = "L26 ONLY SIS STILL ALIVE"
   V20109 = "L27 ONLY SIS OLDR THAN H"
   V20110 = "L28 # SIS STILL ALIVE"
   V20111 = "L29 ANY SIS OLDR THAN H"
   V20112 = "L30 LIVE W BOTH PARENT H"
   V20113 = "L31 SPANISH DESCENT   HD"
   V20114 = "L32 RACE OF HEAD 1"
   V20115 = "L32 RACE OF HEAD 2"
   V20116 = "L33 WTR IN MILIT SERV  H"
   V20117 = "L34 WTR GRADUATED HS  HD"
   V20118 = "L35 MO GRADUATED HS   HD"
   V20119 = "L35 YR GRADUATED HS   HD"
   V20120 = "L36 GRADE LEVEL IF GED H"
   V20121 = "L37 MO LAST IN SCH-GED H"
   V20122 = "L37 YR LAST IN SCH-GED H"
   V20123 = "L38 MO RECEIVED GED   HD"
   V20124 = "L38 YR RECEIVED GED   HD"
   V20125 = "L39 GRD OF SCH FINISH  H"
   V20126 = "L40 MO LAST IN SCH-NONGR"
   V20127 = "L40 YR LAST IN SCH-NONGR"
   V20128 = "L41 WTR ATTEND COLLEGE H"
   V20129 = "L42 MO LAST ATTND COLL H"
   V20130 = "L42 YR LAST ATTND COLL H"
   V20131 = "L43 HGHST YR COLL COMP H"
   V20132 = "L44 WTR RECD COLL DEG  H"
   V20133 = "L45 HGHST COLL DEG REC H"
   V20134 = "L48 MO RECD COLL DEG  HD"
   V20135 = "L48 YR RECD COLL DEG  HD"
   V20136 = "L49 WTR REC OTR DEG/CERT"
   V20137 = "L49 # OTR DEG/CERT REC"
   V20138 = "L50 TYPE OTR DEG/CERT 1"
   V20139 = "L51 FIELD OF DEG/CERT 1"
   V20140 = "L52 INST/ORG DEG/CERT 1"
   V20141 = "L53 MO REC DEG/CERT 1"
   V20142 = "L53 YR REC DEG/CERT 1"
   V20143 = "L50 TYPE OTR DEG/CERT 2"
   V20144 = "L51 FIELD OF DEG/CERT 2"
   V20145 = "L52 INST/ORG DEG/CERT 2"
   V20146 = "L53 MO REC DEG/CERT 2"
   V20147 = "L53 YR REC DEG/CERT 2"
   V20148 = "L50 TYPE OTR DEG/CERT 3"
   V20149 = "L51 FIELD OF DEG/CERT 3"
   V20150 = "L52 INST/ORG DEG/CERT 3"
   V20151 = "L53 MO REC DEG/CERT 3"
   V20152 = "L53 YR REC DEG/CERT 3"
   V20153 = "L55-56 RELIGIOUS PREF  H"
   V20154 = "L57 #YRS WRKD SINCE 18 H"
   V20155 = "L58 #YR WRKD FULL-TIME H"
   V20156 = "FS7 WHO WAS RESPONDENT"
   V20157 = "FS8 # OF INTERVWR CALLS"
   V20158 = "LANGUAGE OF IW ENGLISH?"
   V20159 = "LANGUAGE OF IW SPANISH?"
   V20160 = "LANGUAGE OF IW OTHER?"
   V20161 = "# OF INDIVIDUAL RECORDS"
   V20162 = "H+W 1990 FED TAXES"
   V20163 = "H+W 90 MARGINAL TAX RATE"
   V20164 = "1ST XTRA ERNER 90 TAXES"
   V20165 = "MARG TAX RATE ERNR ONE"
   V20166 = "2ND XTRA ERNER 90 TAXES"
   V20167 = "MARG TAX RATE ERNR TWO"
   V20168 = "3RD XTRA ERNER 90 TAXES"
   V20169 = "MARG TAX RATE ERNR THREE"
   V20170 = "4TH XTRA ERNER 90 TAXES"
   V20171 = "MARG TAX RATE ERNR FOUR"
   V20172 = "5TH XTRA ERNER 90 TAXES"
   V20173 = "MARG TAX RATE ERNR FIVE"
   V20174 = "TOT TAXES ALL XTRA ERNR"
   V20175 = "TOT FAM MONEY Y 90"
   V20176 = "P TOT FAM MNY Y 90 ACC>1"
   V20177 = "P TOT FAM MNY Y 90 ACC>0"
   V20178 = "TOTAL HEAD LABOR Y 90"
   V20179 = "P TOT HD LAB Y 90 ACC>1"
   V20180 = "P TOT HD LAB Y 90 ACC>0"
   V20181 = "WEEKLY FOOD NEEDS-1991"
   V20182 = "ANNUAL NEEDS STD-1990"
   V20183 = "1990 TOT FAM Y/NEEDS"
   V20184 = "ANNUAL NEEDS STD-CENSUS"
   V20185 = "TOT FAM Y/NEEDS-CENSUS"
   V20186 = "ANNUAL FOOD STD"
   V20187 = "HEAD 90 AVG HRLY EARNING"
   V20188 = "WIFE 90 AVG HRLY EARNING"
   V20189 = "REGION OF 1991 INTERVIEW"
   V20190 = "STATE CODE (FIPS)"
   V20191 = "COUNTY CODE (FIPS)"
   V20192 = "RURAL-URBAN CODE (BEALE)"
   V20193 = "REGION 91 HD GREW UP"
   V20194 = "HEAD GEOGRAPHIC MOBILITY"
   V20195 = "ACC 90 Y COMPONENTS"
   V20196 = "# MINOR ASSGMTS IN 91"
   V20197 = "# MAJOR ASSGMTS IN 91"
   V20198 = "COMPLETED ED-HD 91"
   V20199 = "COMPLETED ED-WF 91"
   V20200 = "DECILE: 90 TOT FAM Y"
   V20201 = "# CHILDREN AGE 1-2"
   V20202 = "# CHILDREN AGE 3-5"
   V20203 = "# CHILDREN AGE 6-13"
   V20204 = "# FEM CHILDREN AGE 14-17"
   V20205 = "# MALE CHILDREN 14-17"
   V20206 = "# FEM CHILDREN 18-20"
   V20207 = "# MALE CHILDREN 18-20"
   V20208 = "# FEM CHILDREN 21-29"
   V20209 = "# MALE CHILDREN 21-29"
   V20210 = "# INDS IN ARMED FORCES"
   V20211 = "# INDS INCARCERATED"
   V20212 = "# INDS IN HLTH CARE FACL"
   V20213 = "# INDS IN EDUCATNL FACIL"
   V20214 = "SPLIT SAMPLE FILTER"
   V20215 = "CNTY UNEMP RATE-CENSUS"
   V20216 = "MARITAL STATUS 1991"
   V20217 = "90-91 CNG MARITAL STATUS"
   V20218 = "COUPLE STATUS OF HEAD"
   V20219 = "YR NEW HEAD IN FU"
   V20220 = "YR NEW WIFE IN FU"
   V20221 = "HD-SPOUSE SAMPLE STATUS"
   V20222 = "# 91 S/O FROM THIS FAM"
   V20223 = "91 MAIN FAM ID FOR S/0"
   V20224 = "91ID OF 1ST OTR FU IN HU"
   V20225 = "REL OF 1ST OTHER FU"
   V20226 = "SIZE OF 1ST OTHER FU"
   V20227 = "91ID OF 2ND OTR FU IN HU"
   V20228 = "REL OF 2ND OTHER FU"
   V20229 = "SIZE OF 2ND OTHER FU"
   V20230 = "91ID OF 3RD OTR FU IN HU"
   V20231 = "REL OF 3RD OTHER FU"
   V20232 = "SIZE OF 3RD OTHER FU"
   V20233 = "91ID OF 4TH OTR FU IN HU"
   V20234 = "REL OF 4TH OTHER FU"
   V20235 = "SIZE OF 4TH OTHER FU"
   V20236 = "HOUSEHOLD ID #"
   V20237 = "# BORN TO HD ONLY IN 90"
   V20238 = "#BORN TO W/'W' ONLY IN90"
   V20239 = "#BRN TO H+W JOINTLY IN90"
   V20240 = "# BORN TO OFUMS IN 90"
   V20241 = "WTR PARENT HLTH SUPPL-HD"
   V20242 = "WTR PARENT HLTH SUPPL-WF"
   V20243 = "1991 CORE FAMILY WEIGHT"
   V20244 = "1991 LATINO FAM WEIGHT"
   V20245 = "1991 COMBINED FAM WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V19003=99 THEN V19003=.;
IF V19004=999 THEN V19004=.;
IF V19005=99999 THEN V19005=.;
IF V19006=9 THEN V19006=.;
IF V19008=9 THEN V19008=.;
IF V19009=9 THEN V19009=.;
IF V19010=9 THEN V19010=.;
IF V19017=9999 THEN V19017=.;
IF V19018=999 THEN V19018=.;
IF V19019=99 THEN V19019=.;
IF V19020=9 THEN V19020=.;
IF V19021=99 THEN V19021=.;
IF V19032=9999 THEN V19032=.;
IF V19037=9999 THEN V19037=.;
IF V19055=9 THEN V19055=.;
IF V19056=9 THEN V19056=.;
IF V19057=9 THEN V19057=.;
IF V19058=9 THEN V19058=.;
IF V19059=9 THEN V19059=.;
IF V19060=9 THEN V19060=.;
IF V19061=9 THEN V19061=.;
IF V19062=9 THEN V19062=.;
IF V19063=9 THEN V19063=.;
IF V19064=9 THEN V19064=.;
IF V19065=9 THEN V19065=.;
IF V19066=9 THEN V19066=.;
IF V19085=9 THEN V19085=.;
IF V19086=9 THEN V19086=.;
IF V19087=9 THEN V19087=.;
IF V19088=9 THEN V19088=.;
IF V19089=9 THEN V19089=.;
IF V19090=9 THEN V19090=.;
IF V19091=9 THEN V19091=.;
IF V19092=9 THEN V19092=.;
IF V19093=9 THEN V19093=.;
IF V19094=9 THEN V19094=.;
IF V19095=9 THEN V19095=.;
IF V19096=9 THEN V19096=.;
IF V19104=9 THEN V19104=.;
IF V19113=99 THEN V19113=.;
IF V19114=9 THEN V19114=.;
IF V19115=9 THEN V19115=.;
IF V19116=9 THEN V19116=.;
IF V19117=9 THEN V19117=.;
IF V19118=9 THEN V19118=.;
IF V19119=9 THEN V19119=.;
IF V19120=9 THEN V19120=.;
IF V19121=9 THEN V19121=.;
IF V19122=9 THEN V19122=.;
IF V19123=9 THEN V19123=.;
IF V19124=9 THEN V19124=.;
IF V19125=9 THEN V19125=.;
IF V19143=99 THEN V19143=.;
IF V19145=99 THEN V19145=.;
IF V19147=99 THEN V19147=.;
IF V19152=99999 THEN V19152=.;
IF V19153=99999 THEN V19153=.;
IF V19154=99999 THEN V19154=.;
IF V19161=99 THEN V19161=.;
IF V19164=99 THEN V19164=.;
IF V19166=9 THEN V19166=.;
IF V19167=99 THEN V19167=.;
IF V19169=99 THEN V19169=.;
IF V19171=9 THEN V19171=.;
IF V19174=99 THEN V19174=.;
IF V19176=99 THEN V19176=.;
IF V19178=99 THEN V19178=.;
IF V19182=99 THEN V19182=.;
IF V19185=99 THEN V19185=.;
IF V19187=9 THEN V19187=.;
IF V19188=99 THEN V19188=.;
IF V19190=99 THEN V19190=.;
IF V19194=99 THEN V19194=.;
IF V19196=99 THEN V19196=.;
IF V19198=99 THEN V19198=.;
IF V19202=9 THEN V19202=.;
IF V19203=9 THEN V19203=.;
IF V19204=9 THEN V19204=.;
IF V19205=9 THEN V19205=.;
IF V19206=9 THEN V19206=.;
IF V19207=9 THEN V19207=.;
IF V19208=9 THEN V19208=.;
IF V19209=9 THEN V19209=.;
IF V19210=9 THEN V19210=.;
IF V19211=9 THEN V19211=.;
IF V19212=9 THEN V19212=.;
IF V19213=9 THEN V19213=.;
IF V19214=9 THEN V19214=.;
IF V19215=9 THEN V19215=.;
IF V19216=9 THEN V19216=.;
IF V19217=9 THEN V19217=.;
IF V19218=9 THEN V19218=.;
IF V19219=9 THEN V19219=.;
IF V19220=9 THEN V19220=.;
IF V19221=9 THEN V19221=.;
IF V19222=9 THEN V19222=.;
IF V19223=9 THEN V19223=.;
IF V19224=9 THEN V19224=.;
IF V19225=9 THEN V19225=.;
IF V19226=9 THEN V19226=.;
IF V19227=9 THEN V19227=.;
IF V19228=9 THEN V19228=.;
IF V19229=9 THEN V19229=.;
IF V19230=9 THEN V19230=.;
IF V19231=9 THEN V19231=.;
IF V19232=9 THEN V19232=.;
IF V19233=9 THEN V19233=.;
IF V19234=9 THEN V19234=.;
IF V19235=9 THEN V19235=.;
IF V19236=9 THEN V19236=.;
IF V19237=9 THEN V19237=.;
IF V19238=9 THEN V19238=.;
IF V19239=9 THEN V19239=.;
IF V19240=9 THEN V19240=.;
IF V19241=9 THEN V19241=.;
IF V19242=9 THEN V19242=.;
IF V19243=9 THEN V19243=.;
IF V19244=9 THEN V19244=.;
IF V19245=9 THEN V19245=.;
IF V19246=9 THEN V19246=.;
IF V19247=9 THEN V19247=.;
IF V19248=9 THEN V19248=.;
IF V19249=9 THEN V19249=.;
IF V19250=9 THEN V19250=.;
IF V19251=9 THEN V19251=.;
IF V19252=9 THEN V19252=.;
IF V19253=9 THEN V19253=.;
IF V19254=9 THEN V19254=.;
IF V19255=9 THEN V19255=.;
IF V19256=9 THEN V19256=.;
IF V19257=9 THEN V19257=.;
IF V19258=9 THEN V19258=.;
IF V19259=9 THEN V19259=.;
IF V19260=9 THEN V19260=.;
IF V19261=9 THEN V19261=.;
IF V19262=9 THEN V19262=.;
IF V19263=9 THEN V19263=.;
IF V19264=9 THEN V19264=.;
IF V19265=9 THEN V19265=.;
IF V19266=9 THEN V19266=.;
IF V19267=9 THEN V19267=.;
IF V19268=9 THEN V19268=.;
IF V19269=9 THEN V19269=.;
IF V19270=9 THEN V19270=.;
IF V19271=9 THEN V19271=.;
IF V19272=9 THEN V19272=.;
IF V19273=9 THEN V19273=.;
IF V19344=9999 THEN V19344=.;
IF V19345=999 THEN V19345=.;
IF V19346=9999 THEN V19346=.;
IF V19347=999 THEN V19347=.;
IF V19349=99 THEN V19349=.;
IF V19351=99 THEN V19351=.;
IF V19353=99 THEN V19353=.;
IF V19354=99 THEN V19354=.;
IF V19355=9 THEN V19355=.;
IF V19356=9 THEN V19356=.;
IF V19357=9 THEN V19357=.;
IF V19358=9 THEN V19358=.;
IF V19359=9 THEN V19359=.;
IF V19360=9 THEN V19360=.;
IF V19361=9 THEN V19361=.;
IF V19362=9 THEN V19362=.;
IF V19363=9 THEN V19363=.;
IF V19364=9 THEN V19364=.;
IF V19365=9 THEN V19365=.;
IF V19366=9 THEN V19366=.;
IF V19367=9 THEN V19367=.;
IF V19368=99 THEN V19368=.;
IF V19370=99 THEN V19370=.;
IF V19371=9 THEN V19371=.;
IF V19373=9 THEN V19373=.;
IF V19374=99 THEN V19374=.;
IF V19375=9 THEN V19375=.;
IF V19376=9 THEN V19376=.;
IF V19377=9 THEN V19377=.;
IF V19378=9 THEN V19378=.;
IF V19379=9 THEN V19379=.;
IF V19380=9 THEN V19380=.;
IF V19381=9 THEN V19381=.;
IF V19382=9 THEN V19382=.;
IF V19383=9 THEN V19383=.;
IF V19384=9 THEN V19384=.;
IF V19385=9 THEN V19385=.;
IF V19386=9 THEN V19386=.;
IF V19387=9 THEN V19387=.;
IF V19388=99 THEN V19388=.;
IF V19389=9 THEN V19389=.;
IF V19390=9 THEN V19390=.;
IF V19391=9 THEN V19391=.;
IF V19392=9 THEN V19392=.;
IF V19394=99 THEN V19394=.;
IF V19395=9 THEN V19395=.;
IF V19396=9 THEN V19396=.;
IF V19397=9 THEN V19397=.;
IF V19398=9 THEN V19398=.;
IF V19399=9 THEN V19399=.;
IF V19400=9 THEN V19400=.;
IF V19401=999 THEN V19401=.;
IF V19402=999 THEN V19402=.;
IF V19403=9 THEN V19403=.;
IF V19404=9999 THEN V19404=.;
IF V19405=9 THEN V19405=.;
IF V19406=9999 THEN V19406=.;
IF V19407=9999 THEN V19407=.;
IF V19408=9999 THEN V19408=.;
IF V19409=9 THEN V19409=.;
IF V19410=9999 THEN V19410=.;
IF V19411=9 THEN V19411=.;
IF V19412=9 THEN V19412=.;
IF V19413=9 THEN V19413=.;
IF V19414=9 THEN V19414=.;
IF V19415=9 THEN V19415=.;
IF V19416=9 THEN V19416=.;
IF V19417=9 THEN V19417=.;
IF V19418=9 THEN V19418=.;
IF V19419=9 THEN V19419=.;
IF V19420=999 THEN V19420=.;
IF V19421=99 THEN V19421=.;
IF V19422=99 THEN V19422=.;
IF V19423=9 THEN V19423=.;
IF V19424=99 THEN V19424=.;
IF V19425=99 THEN V19425=.;
IF V19426=9 THEN V19426=.;
IF V19427=99 THEN V19427=.;
IF V19428=9 THEN V19428=.;
IF V19429=99 THEN V19429=.;
IF V19430=99 THEN V19430=.;
IF V19431=99 THEN V19431=.;
IF V19432=99 THEN V19432=.;
IF V19433=9 THEN V19433=.;
IF V19434=99 THEN V19434=.;
IF V19435=9 THEN V19435=.;
IF V19436=999 THEN V19436=.;
IF V19437=9999 THEN V19437=.;
IF V19438=99 THEN V19438=.;
IF V19439=9 THEN V19439=.;
IF V19440=9 THEN V19440=.;
IF V19441=9 THEN V19441=.;
IF V19442=9 THEN V19442=.;
IF V19443=9 THEN V19443=.;
IF V19444=9 THEN V19444=.;
IF V19445=9 THEN V19445=.;
IF V19446=9 THEN V19446=.;
IF V19447=9 THEN V19447=.;
IF V19448=9 THEN V19448=.;
IF V19449=9 THEN V19449=.;
IF V19450=9 THEN V19450=.;
IF V19451=9 THEN V19451=.;
IF V19452=99 THEN V19452=.;
IF V19453=99 THEN V19453=.;
IF V19454=9 THEN V19454=.;
IF V19455=9 THEN V19455=.;
IF V19456=9 THEN V19456=.;
IF V19457=9 THEN V19457=.;
IF V19458=9 THEN V19458=.;
IF V19459=9 THEN V19459=.;
IF V19460=9 THEN V19460=.;
IF V19461=9 THEN V19461=.;
IF V19462=9 THEN V19462=.;
IF V19463=9 THEN V19463=.;
IF V19464=9 THEN V19464=.;
IF V19465=9 THEN V19465=.;
IF V19466=9 THEN V19466=.;
IF V19467=9 THEN V19467=.;
IF V19468=9 THEN V19468=.;
IF V19469=999 THEN V19469=.;
IF V19470=999 THEN V19470=.;
IF V19471=9999 THEN V19471=.;
IF V19472=99 THEN V19472=.;
IF V19473=9 THEN V19473=.;
IF V19474=99 THEN V19474=.;
IF V19475=9 THEN V19475=.;
IF V19476=9 THEN V19476=.;
IF V19477=99 THEN V19477=.;
IF V19478=99 THEN V19478=.;
IF V19479=9 THEN V19479=.;
IF V19480=9999 THEN V19480=.;
IF V19481=99 THEN V19481=.;
IF V19482=9 THEN V19482=.;
IF V19484=9 THEN V19484=.;
IF V19485=99 THEN V19485=.;
IF V19486=9 THEN V19486=.;
IF V19487=99 THEN V19487=.;
IF V19488=9 THEN V19488=.;
IF V19489=99 THEN V19489=.;
IF V19490=9 THEN V19490=.;
IF V19491=99 THEN V19491=.;
IF V19492=9 THEN V19492=.;
IF V19493=99 THEN V19493=.;
IF V19494=9 THEN V19494=.;
IF V19495=99 THEN V19495=.;
IF V19496=99 THEN V19496=.;
IF V19497=99 THEN V19497=.;
IF V19498=9 THEN V19498=.;
IF V19499=9 THEN V19499=.;
IF V19500=9 THEN V19500=.;
IF V19501=9 THEN V19501=.;
IF V19502=999 THEN V19502=.;
IF V19503=999 THEN V19503=.;
IF V19504=9999 THEN V19504=.;
IF V19505=99 THEN V19505=.;
IF V19506=99 THEN V19506=.;
IF V19507=99 THEN V19507=.;
IF V19508=99 THEN V19508=.;
IF V19509=9 THEN V19509=.;
IF V19510=9 THEN V19510=.;
IF V19511=9 THEN V19511=.;
IF V19512=9 THEN V19512=.;
IF V19513=9 THEN V19513=.;
IF V19514=9 THEN V19514=.;
IF V19515=9 THEN V19515=.;
IF V19516=9 THEN V19516=.;
IF V19517=9 THEN V19517=.;
IF V19518=9 THEN V19518=.;
IF V19519=9 THEN V19519=.;
IF V19520=9 THEN V19520=.;
IF V19521=9 THEN V19521=.;
IF V19522=99 THEN V19522=.;
IF V19523=99 THEN V19523=.;
IF V19524=9 THEN V19524=.;
IF V19525=999 THEN V19525=.;
IF V19526=999 THEN V19526=.;
IF V19527=9999 THEN V19527=.;
IF V19528=99 THEN V19528=.;
IF V19529=99 THEN V19529=.;
IF V19530=99 THEN V19530=.;
IF V19531=99 THEN V19531=.;
IF V19532=9 THEN V19532=.;
IF V19533=9 THEN V19533=.;
IF V19534=9 THEN V19534=.;
IF V19535=9 THEN V19535=.;
IF V19536=9 THEN V19536=.;
IF V19537=9 THEN V19537=.;
IF V19538=9 THEN V19538=.;
IF V19539=9 THEN V19539=.;
IF V19540=9 THEN V19540=.;
IF V19541=9 THEN V19541=.;
IF V19542=9 THEN V19542=.;
IF V19543=9 THEN V19543=.;
IF V19544=9 THEN V19544=.;
IF V19545=99 THEN V19545=.;
IF V19546=99 THEN V19546=.;
IF V19547=9 THEN V19547=.;
IF V19548=9 THEN V19548=.;
IF V19549=9 THEN V19549=.;
IF V19550=9 THEN V19550=.;
IF V19551=9 THEN V19551=.;
IF V19552=9 THEN V19552=.;
IF V19553=9 THEN V19553=.;
IF V19554=9 THEN V19554=.;
IF V19555=9 THEN V19555=.;
IF V19556=99 THEN V19556=.;
IF V19557=9 THEN V19557=.;
IF V19558=99 THEN V19558=.;
IF V19559=99 THEN V19559=.;
IF V19560=9 THEN V19560=.;
IF V19561=99 THEN V19561=.;
IF V19562=999 THEN V19562=.;
IF V19563=999 THEN V19563=.;
IF V19564=9 THEN V19564=.;
IF V19565=9 THEN V19565=.;
IF V19566=9 THEN V19566=.;
IF V19567=9 THEN V19567=.;
IF V19568=99 THEN V19568=.;
IF V19569=99 THEN V19569=.;
IF V19570=9 THEN V19570=.;
IF V19571=99 THEN V19571=.;
IF V19572=99 THEN V19572=.;
IF V19573=9 THEN V19573=.;
IF V19574=99 THEN V19574=.;
IF V19575=9 THEN V19575=.;
IF V19576=99 THEN V19576=.;
IF V19577=99 THEN V19577=.;
IF V19578=99 THEN V19578=.;
IF V19579=99 THEN V19579=.;
IF V19580=9 THEN V19580=.;
IF V19581=99 THEN V19581=.;
IF V19582=9 THEN V19582=.;
IF V19583=999 THEN V19583=.;
IF V19584=9999 THEN V19584=.;
IF V19585=99 THEN V19585=.;
IF V19586=9 THEN V19586=.;
IF V19587=9 THEN V19587=.;
IF V19588=9 THEN V19588=.;
IF V19589=9 THEN V19589=.;
IF V19590=9 THEN V19590=.;
IF V19591=9 THEN V19591=.;
IF V19592=9 THEN V19592=.;
IF V19593=9 THEN V19593=.;
IF V19594=9 THEN V19594=.;
IF V19595=9 THEN V19595=.;
IF V19596=9 THEN V19596=.;
IF V19597=9 THEN V19597=.;
IF V19598=9 THEN V19598=.;
IF V19599=99 THEN V19599=.;
IF V19600=99 THEN V19600=.;
IF V19601=9 THEN V19601=.;
IF V19602=9 THEN V19602=.;
IF V19603=9 THEN V19603=.;
IF V19604=9 THEN V19604=.;
IF V19605=9 THEN V19605=.;
IF V19606=9 THEN V19606=.;
IF V19607=9 THEN V19607=.;
IF V19608=9 THEN V19608=.;
IF V19609=9 THEN V19609=.;
IF V19610=9 THEN V19610=.;
IF V19611=9 THEN V19611=.;
IF V19612=9 THEN V19612=.;
IF V19613=9 THEN V19613=.;
IF V19614=9 THEN V19614=.;
IF V19615=9 THEN V19615=.;
IF V19616=999 THEN V19616=.;
IF V19617=999 THEN V19617=.;
IF V19618=9999 THEN V19618=.;
IF V19619=99 THEN V19619=.;
IF V19620=9 THEN V19620=.;
IF V19621=99 THEN V19621=.;
IF V19622=9 THEN V19622=.;
IF V19623=9 THEN V19623=.;
IF V19624=99 THEN V19624=.;
IF V19625=99 THEN V19625=.;
IF V19626=9 THEN V19626=.;
IF V19627=9999 THEN V19627=.;
IF V19628=99 THEN V19628=.;
IF V19629=9 THEN V19629=.;
IF V19631=9 THEN V19631=.;
IF V19632=99 THEN V19632=.;
IF V19633=9 THEN V19633=.;
IF V19634=99 THEN V19634=.;
IF V19635=9 THEN V19635=.;
IF V19636=99 THEN V19636=.;
IF V19637=9 THEN V19637=.;
IF V19638=99 THEN V19638=.;
IF V19639=9 THEN V19639=.;
IF V19640=99 THEN V19640=.;
IF V19641=9 THEN V19641=.;
IF V19642=99 THEN V19642=.;
IF V19643=99 THEN V19643=.;
IF V19644=99 THEN V19644=.;
IF V19645=9 THEN V19645=.;
IF V19646=9 THEN V19646=.;
IF V19647=9 THEN V19647=.;
IF V19648=9 THEN V19648=.;
IF V19649=999 THEN V19649=.;
IF V19650=999 THEN V19650=.;
IF V19651=9999 THEN V19651=.;
IF V19652=99 THEN V19652=.;
IF V19653=99 THEN V19653=.;
IF V19654=99 THEN V19654=.;
IF V19655=99 THEN V19655=.;
IF V19656=9 THEN V19656=.;
IF V19657=9 THEN V19657=.;
IF V19658=9 THEN V19658=.;
IF V19659=9 THEN V19659=.;
IF V19660=9 THEN V19660=.;
IF V19661=9 THEN V19661=.;
IF V19662=9 THEN V19662=.;
IF V19663=9 THEN V19663=.;
IF V19664=9 THEN V19664=.;
IF V19665=9 THEN V19665=.;
IF V19666=9 THEN V19666=.;
IF V19667=9 THEN V19667=.;
IF V19668=9 THEN V19668=.;
IF V19669=99 THEN V19669=.;
IF V19670=99 THEN V19670=.;
IF V19671=9 THEN V19671=.;
IF V19672=999 THEN V19672=.;
IF V19673=999 THEN V19673=.;
IF V19674=9999 THEN V19674=.;
IF V19675=99 THEN V19675=.;
IF V19676=99 THEN V19676=.;
IF V19677=99 THEN V19677=.;
IF V19678=99 THEN V19678=.;
IF V19679=9 THEN V19679=.;
IF V19680=9 THEN V19680=.;
IF V19681=9 THEN V19681=.;
IF V19682=9 THEN V19682=.;
IF V19683=9 THEN V19683=.;
IF V19684=9 THEN V19684=.;
IF V19685=9 THEN V19685=.;
IF V19686=9 THEN V19686=.;
IF V19687=9 THEN V19687=.;
IF V19688=9 THEN V19688=.;
IF V19689=9 THEN V19689=.;
IF V19690=9 THEN V19690=.;
IF V19691=9 THEN V19691=.;
IF V19692=99 THEN V19692=.;
IF V19693=99 THEN V19693=.;
IF V19696=99 THEN V19696=.;
IF V19697=9 THEN V19697=.;
IF V19698=9 THEN V19698=.;
IF V19699=9 THEN V19699=.;
IF V19700=9 THEN V19700=.;
IF V19701=9 THEN V19701=.;
IF V19702=9 THEN V19702=.;
IF V19703=999 THEN V19703=.;
IF V19704=999 THEN V19704=.;
IF V19705=9 THEN V19705=.;
IF V19706=9999 THEN V19706=.;
IF V19707=9 THEN V19707=.;
IF V19708=9999 THEN V19708=.;
IF V19709=9999 THEN V19709=.;
IF V19710=9999 THEN V19710=.;
IF V19711=9 THEN V19711=.;
IF V19712=9999 THEN V19712=.;
IF V19713=9 THEN V19713=.;
IF V19714=9 THEN V19714=.;
IF V19715=9 THEN V19715=.;
IF V19716=9 THEN V19716=.;
IF V19717=9 THEN V19717=.;
IF V19718=9 THEN V19718=.;
IF V19719=9 THEN V19719=.;
IF V19720=9 THEN V19720=.;
IF V19721=9 THEN V19721=.;
IF V19722=999 THEN V19722=.;
IF V19723=99 THEN V19723=.;
IF V19724=99 THEN V19724=.;
IF V19725=9 THEN V19725=.;
IF V19726=99 THEN V19726=.;
IF V19727=99 THEN V19727=.;
IF V19728=9 THEN V19728=.;
IF V19729=99 THEN V19729=.;
IF V19730=9 THEN V19730=.;
IF V19731=99 THEN V19731=.;
IF V19732=99 THEN V19732=.;
IF V19733=99 THEN V19733=.;
IF V19734=99 THEN V19734=.;
IF V19735=9 THEN V19735=.;
IF V19736=99 THEN V19736=.;
IF V19737=9 THEN V19737=.;
IF V19738=999 THEN V19738=.;
IF V19739=9999 THEN V19739=.;
IF V19740=99 THEN V19740=.;
IF V19741=9 THEN V19741=.;
IF V19742=9 THEN V19742=.;
IF V19743=9 THEN V19743=.;
IF V19744=9 THEN V19744=.;
IF V19745=9 THEN V19745=.;
IF V19746=9 THEN V19746=.;
IF V19747=9 THEN V19747=.;
IF V19748=9 THEN V19748=.;
IF V19749=9 THEN V19749=.;
IF V19750=9 THEN V19750=.;
IF V19751=9 THEN V19751=.;
IF V19752=9 THEN V19752=.;
IF V19753=9 THEN V19753=.;
IF V19754=99 THEN V19754=.;
IF V19755=99 THEN V19755=.;
IF V19756=9 THEN V19756=.;
IF V19757=9 THEN V19757=.;
IF V19758=9 THEN V19758=.;
IF V19759=9 THEN V19759=.;
IF V19760=9 THEN V19760=.;
IF V19761=9 THEN V19761=.;
IF V19762=9 THEN V19762=.;
IF V19763=9 THEN V19763=.;
IF V19764=9 THEN V19764=.;
IF V19765=9 THEN V19765=.;
IF V19766=9 THEN V19766=.;
IF V19767=9 THEN V19767=.;
IF V19768=9 THEN V19768=.;
IF V19769=9 THEN V19769=.;
IF V19770=9 THEN V19770=.;
IF V19771=999 THEN V19771=.;
IF V19772=999 THEN V19772=.;
IF V19773=9999 THEN V19773=.;
IF V19774=99 THEN V19774=.;
IF V19775=9 THEN V19775=.;
IF V19776=99 THEN V19776=.;
IF V19777=9 THEN V19777=.;
IF V19778=9 THEN V19778=.;
IF V19779=99 THEN V19779=.;
IF V19780=99 THEN V19780=.;
IF V19781=9 THEN V19781=.;
IF V19782=9999 THEN V19782=.;
IF V19783=99 THEN V19783=.;
IF V19784=9 THEN V19784=.;
IF V19786=9 THEN V19786=.;
IF V19787=99 THEN V19787=.;
IF V19788=9 THEN V19788=.;
IF V19789=99 THEN V19789=.;
IF V19790=9 THEN V19790=.;
IF V19791=99 THEN V19791=.;
IF V19792=9 THEN V19792=.;
IF V19793=99 THEN V19793=.;
IF V19794=9 THEN V19794=.;
IF V19795=99 THEN V19795=.;
IF V19796=9 THEN V19796=.;
IF V19797=99 THEN V19797=.;
IF V19798=99 THEN V19798=.;
IF V19799=99 THEN V19799=.;
IF V19800=9 THEN V19800=.;
IF V19801=9 THEN V19801=.;
IF V19802=9 THEN V19802=.;
IF V19803=9 THEN V19803=.;
IF V19804=999 THEN V19804=.;
IF V19805=999 THEN V19805=.;
IF V19806=9999 THEN V19806=.;
IF V19807=99 THEN V19807=.;
IF V19808=99 THEN V19808=.;
IF V19809=99 THEN V19809=.;
IF V19810=99 THEN V19810=.;
IF V19811=9 THEN V19811=.;
IF V19812=9 THEN V19812=.;
IF V19813=9 THEN V19813=.;
IF V19814=9 THEN V19814=.;
IF V19815=9 THEN V19815=.;
IF V19816=9 THEN V19816=.;
IF V19817=9 THEN V19817=.;
IF V19818=9 THEN V19818=.;
IF V19819=9 THEN V19819=.;
IF V19820=9 THEN V19820=.;
IF V19821=9 THEN V19821=.;
IF V19822=9 THEN V19822=.;
IF V19823=9 THEN V19823=.;
IF V19824=99 THEN V19824=.;
IF V19825=99 THEN V19825=.;
IF V19826=9 THEN V19826=.;
IF V19827=999 THEN V19827=.;
IF V19828=999 THEN V19828=.;
IF V19829=9999 THEN V19829=.;
IF V19830=99 THEN V19830=.;
IF V19831=99 THEN V19831=.;
IF V19832=99 THEN V19832=.;
IF V19833=99 THEN V19833=.;
IF V19834=9 THEN V19834=.;
IF V19835=9 THEN V19835=.;
IF V19836=9 THEN V19836=.;
IF V19837=9 THEN V19837=.;
IF V19838=9 THEN V19838=.;
IF V19839=9 THEN V19839=.;
IF V19840=9 THEN V19840=.;
IF V19841=9 THEN V19841=.;
IF V19842=9 THEN V19842=.;
IF V19843=9 THEN V19843=.;
IF V19844=9 THEN V19844=.;
IF V19845=9 THEN V19845=.;
IF V19846=9 THEN V19846=.;
IF V19847=99 THEN V19847=.;
IF V19848=99 THEN V19848=.;
IF V19849=9 THEN V19849=.;
IF V19850=9 THEN V19850=.;
IF V19851=9 THEN V19851=.;
IF V19852=9 THEN V19852=.;
IF V19853=9 THEN V19853=.;
IF V19854=9 THEN V19854=.;
IF V19855=9 THEN V19855=.;
IF V19856=9 THEN V19856=.;
IF V19857=9 THEN V19857=.;
IF V19858=99 THEN V19858=.;
IF V19859=9 THEN V19859=.;
IF V19860=99 THEN V19860=.;
IF V19861=99 THEN V19861=.;
IF V19862=9 THEN V19862=.;
IF V19863=99 THEN V19863=.;
IF V19864=999 THEN V19864=.;
IF V19865=999 THEN V19865=.;
IF V19866=9 THEN V19866=.;
IF V19867=9 THEN V19867=.;
IF V19868=9 THEN V19868=.;
IF V19869=9 THEN V19869=.;
IF V19870=99 THEN V19870=.;
IF V19871=99 THEN V19871=.;
IF V19872=9 THEN V19872=.;
IF V19873=99 THEN V19873=.;
IF V19874=99 THEN V19874=.;
IF V19875=9 THEN V19875=.;
IF V19876=99 THEN V19876=.;
IF V19877=9 THEN V19877=.;
IF V19878=99 THEN V19878=.;
IF V19879=99 THEN V19879=.;
IF V19880=99 THEN V19880=.;
IF V19881=99 THEN V19881=.;
IF V19882=9 THEN V19882=.;
IF V19883=99 THEN V19883=.;
IF V19884=9 THEN V19884=.;
IF V19885=999 THEN V19885=.;
IF V19886=9999 THEN V19886=.;
IF V19887=99 THEN V19887=.;
IF V19888=9 THEN V19888=.;
IF V19889=9 THEN V19889=.;
IF V19890=9 THEN V19890=.;
IF V19891=9 THEN V19891=.;
IF V19892=9 THEN V19892=.;
IF V19893=9 THEN V19893=.;
IF V19894=9 THEN V19894=.;
IF V19895=9 THEN V19895=.;
IF V19896=9 THEN V19896=.;
IF V19897=9 THEN V19897=.;
IF V19898=9 THEN V19898=.;
IF V19899=9 THEN V19899=.;
IF V19900=9 THEN V19900=.;
IF V19901=99 THEN V19901=.;
IF V19902=99 THEN V19902=.;
IF V19903=9 THEN V19903=.;
IF V19904=9 THEN V19904=.;
IF V19905=9 THEN V19905=.;
IF V19906=9 THEN V19906=.;
IF V19907=9 THEN V19907=.;
IF V19908=9 THEN V19908=.;
IF V19909=9 THEN V19909=.;
IF V19910=9 THEN V19910=.;
IF V19911=9 THEN V19911=.;
IF V19912=9 THEN V19912=.;
IF V19913=9 THEN V19913=.;
IF V19914=9 THEN V19914=.;
IF V19915=9 THEN V19915=.;
IF V19916=9 THEN V19916=.;
IF V19917=9 THEN V19917=.;
IF V19918=999 THEN V19918=.;
IF V19919=999 THEN V19919=.;
IF V19920=9999 THEN V19920=.;
IF V19921=99 THEN V19921=.;
IF V19922=9 THEN V19922=.;
IF V19923=99 THEN V19923=.;
IF V19924=9 THEN V19924=.;
IF V19925=9 THEN V19925=.;
IF V19926=99 THEN V19926=.;
IF V19927=99 THEN V19927=.;
IF V19928=9 THEN V19928=.;
IF V19929=9999 THEN V19929=.;
IF V19930=99 THEN V19930=.;
IF V19931=9 THEN V19931=.;
IF V19933=9 THEN V19933=.;
IF V19934=99 THEN V19934=.;
IF V19935=9 THEN V19935=.;
IF V19936=99 THEN V19936=.;
IF V19937=9 THEN V19937=.;
IF V19938=99 THEN V19938=.;
IF V19939=9 THEN V19939=.;
IF V19940=99 THEN V19940=.;
IF V19941=9 THEN V19941=.;
IF V19942=99 THEN V19942=.;
IF V19943=9 THEN V19943=.;
IF V19944=99 THEN V19944=.;
IF V19945=99 THEN V19945=.;
IF V19946=99 THEN V19946=.;
IF V19947=9 THEN V19947=.;
IF V19948=9 THEN V19948=.;
IF V19949=9 THEN V19949=.;
IF V19950=9 THEN V19950=.;
IF V19951=999 THEN V19951=.;
IF V19952=999 THEN V19952=.;
IF V19953=9999 THEN V19953=.;
IF V19954=99 THEN V19954=.;
IF V19955=99 THEN V19955=.;
IF V19956=99 THEN V19956=.;
IF V19957=99 THEN V19957=.;
IF V19958=9 THEN V19958=.;
IF V19959=9 THEN V19959=.;
IF V19960=9 THEN V19960=.;
IF V19961=9 THEN V19961=.;
IF V19962=9 THEN V19962=.;
IF V19963=9 THEN V19963=.;
IF V19964=9 THEN V19964=.;
IF V19965=9 THEN V19965=.;
IF V19966=9 THEN V19966=.;
IF V19967=9 THEN V19967=.;
IF V19968=9 THEN V19968=.;
IF V19969=9 THEN V19969=.;
IF V19970=9 THEN V19970=.;
IF V19971=99 THEN V19971=.;
IF V19972=99 THEN V19972=.;
IF V19973=9 THEN V19973=.;
IF V19974=999 THEN V19974=.;
IF V19975=999 THEN V19975=.;
IF V19976=9999 THEN V19976=.;
IF V19977=99 THEN V19977=.;
IF V19978=99 THEN V19978=.;
IF V19979=99 THEN V19979=.;
IF V19980=99 THEN V19980=.;
IF V19981=9 THEN V19981=.;
IF V19982=9 THEN V19982=.;
IF V19983=9 THEN V19983=.;
IF V19984=9 THEN V19984=.;
IF V19985=9 THEN V19985=.;
IF V19986=9 THEN V19986=.;
IF V19987=9 THEN V19987=.;
IF V19988=9 THEN V19988=.;
IF V19989=9 THEN V19989=.;
IF V19990=9 THEN V19990=.;
IF V19991=9 THEN V19991=.;
IF V19992=9 THEN V19992=.;
IF V19993=9 THEN V19993=.;
IF V19994=99 THEN V19994=.;
IF V19995=99 THEN V19995=.;
IF V19997=99 THEN V19997=.;
IF V19998=99 THEN V19998=.;
IF V19999=9 THEN V19999=.;
IF V20000=99999 THEN V20000=.;
IF V20001=9 THEN V20001=.;
IF V20002=999999 THEN V20002=.;
IF V20003=9 THEN V20003=.;
IF V20004=99 THEN V20004=.;
IF V20005=9 THEN V20005=.;
IF V20006=9 THEN V20006=.;
IF V20007=9 THEN V20007=.;
IF V20008=9 THEN V20008=.;
IF V20009=999999 THEN V20009=.;
IF V20010=999999 THEN V20010=.;
IF V20011=9 THEN V20011=.;
IF V20012=9 THEN V20012=.;
IF V20013=99 THEN V20013=.;
IF V20014=99 THEN V20014=.;
IF V20015=99 THEN V20015=.;
IF V20016=99 THEN V20016=.;
IF V20017=9 THEN V20017=.;
IF V20018=9 THEN V20018=.;
IF V20019=9 THEN V20019=.;
IF V20020=9 THEN V20020=.;
IF V20021=9 THEN V20021=.;
IF V20022=9 THEN V20022=.;
IF V20023=9 THEN V20023=.;
IF V20024=9 THEN V20024=.;
IF V20025=9 THEN V20025=.;
IF V20027=9 THEN V20027=.;
IF V20028=9 THEN V20028=.;
IF V20029=9 THEN V20029=.;
IF V20030=9 THEN V20030=.;
IF V20032=9 THEN V20032=.;
IF V20034=9 THEN V20034=.;
IF V20035=9 THEN V20035=.;
IF V20036=9 THEN V20036=.;
IF V20037=99 THEN V20037=.;
IF V20038=9 THEN V20038=.;
IF V20039=9 THEN V20039=.;
IF V20040=99 THEN V20040=.;
IF V20041=9 THEN V20041=.;
IF V20042=9 THEN V20042=.;
IF V20043=99 THEN V20043=.;
IF V20044=9 THEN V20044=.;
IF V20045=9 THEN V20045=.;
IF V20046=99 THEN V20046=.;
IF V20047=9 THEN V20047=.;
IF V20048=9 THEN V20048=.;
IF V20049=9 THEN V20049=.;
IF V20050=9 THEN V20050=.;
IF V20051=9 THEN V20051=.;
IF V20052=9 THEN V20052=.;
IF V20053=99 THEN V20053=.;
IF V20054=99 THEN V20054=.;
IF V20055=99 THEN V20055=.;
IF V20056=99 THEN V20056=.;
IF V20057=99 THEN V20057=.;
IF V20058=99 THEN V20058=.;
IF V20059=9 THEN V20059=.;
IF V20060=99 THEN V20060=.;
IF V20061=9 THEN V20061=.;
IF V20062=9 THEN V20062=.;
IF V20063=99 THEN V20063=.;
IF V20064=99 THEN V20064=.;
IF V20065=9 THEN V20065=.;
IF V20066=9 THEN V20066=.;
IF V20067=9 THEN V20067=.;
IF V20068=99 THEN V20068=.;
IF V20069=99 THEN V20069=.;
IF V20070=99 THEN V20070=.;
IF V20071=9 THEN V20071=.;
IF V20072=99 THEN V20072=.;
IF V20073=99 THEN V20073=.;
IF V20074=99 THEN V20074=.;
IF V20075=9 THEN V20075=.;
IF V20076=99 THEN V20076=.;
IF V20077=99 THEN V20077=.;
IF V20078=99 THEN V20078=.;
IF V20079=99 THEN V20079=.;
IF V20080=99 THEN V20080=.;
IF V20081=99 THEN V20081=.;
IF V20083=99 THEN V20083=.;
IF V20084=999 THEN V20084=.;
IF V20085=99 THEN V20085=.;
IF V20086=999 THEN V20086=.;
IF V20087=9 THEN V20087=.;
IF V20088=9 THEN V20088=.;
IF V20089=9 THEN V20089=.;
IF V20090=9 THEN V20090=.;
IF V20091=99 THEN V20091=.;
IF V20092=999 THEN V20092=.;
IF V20093=9 THEN V20093=.;
IF V20094=9 THEN V20094=.;
IF V20095=9 THEN V20095=.;
IF V20096=9 THEN V20096=.;
IF V20097=9 THEN V20097=.;
IF V20098=9 THEN V20098=.;
IF V20099=9 THEN V20099=.;
IF V20100=9 THEN V20100=.;
IF V20101=99 THEN V20101=.;
IF V20102=9 THEN V20102=.;
IF V20103=9 THEN V20103=.;
IF V20104=99 THEN V20104=.;
IF V20105=9 THEN V20105=.;
IF V20106=9 THEN V20106=.;
IF V20107=99 THEN V20107=.;
IF V20108=9 THEN V20108=.;
IF V20109=9 THEN V20109=.;
IF V20110=99 THEN V20110=.;
IF V20111=9 THEN V20111=.;
IF V20112=9 THEN V20112=.;
IF V20113=9 THEN V20113=.;
IF V20114=9 THEN V20114=.;
IF V20115=9 THEN V20115=.;
IF V20116=9 THEN V20116=.;
IF V20117=9 THEN V20117=.;
IF V20118=99 THEN V20118=.;
IF V20119=99 THEN V20119=.;
IF V20120=99 THEN V20120=.;
IF V20121=99 THEN V20121=.;
IF V20122=99 THEN V20122=.;
IF V20123=99 THEN V20123=.;
IF V20124=99 THEN V20124=.;
IF V20125=99 THEN V20125=.;
IF V20126=99 THEN V20126=.;
IF V20127=99 THEN V20127=.;
IF V20128=9 THEN V20128=.;
IF V20129=99 THEN V20129=.;
IF V20130=99 THEN V20130=.;
IF V20131=9 THEN V20131=.;
IF V20132=9 THEN V20132=.;
IF V20133=99 THEN V20133=.;
IF V20134=99 THEN V20134=.;
IF V20135=99 THEN V20135=.;
IF V20136=9 THEN V20136=.;
IF V20137=9 THEN V20137=.;
IF V20138=9 THEN V20138=.;
IF V20139=99 THEN V20139=.;
IF V20140=99 THEN V20140=.;
IF V20141=99 THEN V20141=.;
IF V20142=99 THEN V20142=.;
IF V20143=9 THEN V20143=.;
IF V20144=99 THEN V20144=.;
IF V20145=99 THEN V20145=.;
IF V20146=99 THEN V20146=.;
IF V20147=99 THEN V20147=.;
IF V20148=9 THEN V20148=.;
IF V20149=99 THEN V20149=.;
IF V20150=99 THEN V20150=.;
IF V20151=99 THEN V20151=.;
IF V20152=99 THEN V20152=.;
IF V20153=99 THEN V20153=.;
IF V20154=99 THEN V20154=.;
IF V20155=99 THEN V20155=.;
IF V20156=9 THEN V20156=.;
IF V20157=99 THEN V20157=.;
IF V20158=9 THEN V20158=.;
IF V20159=9 THEN V20159=.;
IF V20160=9 THEN V20160=.;
IF V20162=999999 THEN V20162=.;
IF V20163=99 THEN V20163=.;
IF V20164=99999 THEN V20164=.;
IF V20165=99 THEN V20165=.;
IF V20166=99999 THEN V20166=.;
IF V20167=99 THEN V20167=.;
IF V20168=99999 THEN V20168=.;
IF V20169=99 THEN V20169=.;
IF V20170=99999 THEN V20170=.;
IF V20171=99 THEN V20171=.;
IF V20172=99999 THEN V20172=.;
IF V20173=99 THEN V20173=.;
IF V20174=999999 THEN V20174=.;
IF V20189=9 THEN V20189=.;
IF V20190=99 THEN V20190=.;
IF V20191=999 THEN V20191=.;
IF V20192=99 THEN V20192=.;
IF V20193=9 THEN V20193=.;
IF V20194=9 THEN V20194=.;
IF V20198=99 THEN V20198=.;
IF V20199=99 THEN V20199=.;
IF V20215=99 THEN V20215=.;
IF V20219=99 THEN V20219=.;
IF V20237=9 THEN V20237=.;
IF V20238=9 THEN V20238=.;
IF V20239=9 THEN V20239=.;
IF V20240=9 THEN V20240=.;
 
file rawdat lrecl=2336;
put    
v19002
v19010
v19024
v19025
v19026
v19033
v19034
v19044
v19045
v19047
v19074
v19075
v19077
v19105
v19106
v19107
v19108
v19109
v19110
v19111
v19112
v19136
v19144
v19146
v19149
v19151
v19201
v19300
v19301
v19303
v19317
v19346
v19348
v19349
v19350
v19351
v19372
v19373
v19374
v19375
v19387
v19388
v19389
v19393
v19396
v19420
v19496
v19497
v19556
v19567
v19643
v19644
v19695
v19697
v19698
v19722
v19781
v19798
v19799
v19858
v19869
v19945
v19946
v20009
v20013
v20022
v20052
v20059
v20062
v20082
v20114
v20117
v20128
v20132
v20175
v20178
v20182
v20189
v20198
v20199
v20216
v20243
v30690
;

 proc means;
 run; 
